/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.types;

import io.sealights.onpremise.agents.commons.instrument.types.SignatureConstants;
import io.sealights.onpremise.agents.commons.instrument.utils.HashingUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class LineSignature {
    private List<String> hash = new ArrayList<String>();
    private final int lineNumber;
    private String methodName;
    private int methodIndex = SignatureConstants.UNDEFINED_INDEX;

    public LineSignature(int lineNumber, String methodName) {
        this.lineNumber = lineNumber;
        this.methodName = methodName;
    }

    public LineSignature(int lineNumber, String methodName, int methodIndex) {
        this(lineNumber, methodName);
        this.methodIndex = methodIndex;
    }

    public void mergeHashes(LineSignature otherLine) {
        this.hash.addAll(otherLine.hash);
    }

    public String getMD5() {
        return new HashingUtils().toMD5(this.hash.toString() + this.methodName);
    }

    public String toString() {
        return String.format("lineNumber=%s, methodName=%s, methodIndex=%s, hash=%s", this.lineNumber, this.methodName, this.methodIndex, this.hash);
    }

    @Generated
    public List<String> getHash() {
        return this.hash;
    }

    @Generated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Generated
    public int getMethodIndex() {
        return this.methodIndex;
    }
}

