/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.types;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.LineSignature;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.types.SourceLanguage;
import io.sealights.onpremise.agents.commons.instrument.visitors.ClassVisitorHelper;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class ClassSignature {
    private static final String KOTLIN_METADATA_ANNOTATION_CLASS = "kotlin.Metadata";
    private static final String GROOVY_FILE_EXTENSION = ".groovy";
    private String className;
    private String hash;
    private String relativePath;
    private String sourceFile;
    private String classPackage;
    private HashMap<String, MethodSignature> methods = new HashMap();
    private ArrayList<LineSignature> lines;
    private boolean testClass;
    private int access;
    private String superName;
    private List<String> interfaces = new ArrayList<String>();
    private List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
    private static final String OBJECT_CLASS = "java/lang/Object";

    public ClassSignature(int access, String className, String superName, String[] interfaces) {
        this.access = access;
        this.className = className;
        this.classPackage = ClassVisitorHelper.resolveBinaryPackageName(className);
        this.superName = this.resolveSuperName(superName);
        this.setInterfaces(interfaces);
    }

    public void updateRelativePath() {
        this.relativePath = this.classPackage + "/" + this.sourceFile;
    }

    public void addMethod(MethodSignature sig) {
        this.methods.put(sig.getElementId(), sig);
    }

    public void addMethods(List<MethodSignature> methodSignatures) {
        for (MethodSignature methodSignature : methodSignatures) {
            this.addMethod(methodSignature);
        }
    }

    public MethodSignature getMethod(String methodId) {
        return this.methods.get(methodId);
    }

    public List<MethodSignature> getMethods() {
        return new ArrayList<MethodSignature>(this.methods.values());
    }

    public boolean isAbstractClass() {
        return (this.access & 0x400) != 0;
    }

    public SourceLanguage getSourceLanguage() {
        if (this.isGroovyClass()) {
            return SourceLanguage.GROOVY;
        }
        if (this.isKotlinClass()) {
            return SourceLanguage.KOTLIN;
        }
        return SourceLanguage.JAVA;
    }

    public boolean isGroovyClass() {
        return this.sourceFile != null && this.sourceFile.endsWith(GROOVY_FILE_EXTENSION);
    }

    public boolean isKotlinClass() {
        for (AnnotationInfo annotationInfo : this.annotations) {
            if (!annotationInfo.getClassName().equals(KOTLIN_METADATA_ANNOTATION_CLASS)) continue;
            return true;
        }
        return false;
    }

    private String resolveSuperName(String superName) {
        if (superName.equals(OBJECT_CLASS)) {
            return null;
        }
        return ClassVisitorHelper.slashToDot(superName);
    }

    private void setInterfaces(String[] interfacesBinaryNames) {
        for (String binaryName : interfacesBinaryNames) {
            this.interfaces.add(ClassVisitorHelper.slashToDot(binaryName));
        }
    }

    public String toString() {
        return String.format("ClassSignature {className=%s, hash=%s, relativePath=%s, sourceFile=%s, classPackage=%s, superClass='%s', testClass=%s, interfaces:%s, %nmethods:%s, %nlines:%s}", this.className, this.hash, this.relativePath, this.sourceFile, this.classPackage, this.superName, this.testClass, this.interfaces, ToStringFormatter.toString(this.methods), ToStringFormatter.toString(this.lines));
    }

    public String toStringCompact() {
        return String.format("className=%s, superClass='%s', testClass=%s, interfaces:%s, relativePath=%s, methods(%s):%s, lines size=%s", this.className, this.superName, this.testClass, this.interfaces, this.relativePath, this.methods.size(), this.methods.keySet(), this.lines.size());
    }

    public HashMap<String, MethodSignature> getMethodsMap() {
        return this.methods;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getRelativePath() {
        return this.relativePath;
    }

    @Generated
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Generated
    public String getClassPackage() {
        return this.classPackage;
    }

    @Generated
    public ArrayList<LineSignature> getLines() {
        return this.lines;
    }

    @Generated
    public boolean isTestClass() {
        return this.testClass;
    }

    @Generated
    public int getAccess() {
        return this.access;
    }

    @Generated
    public String getSuperName() {
        return this.superName;
    }

    @Generated
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    @Generated
    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    @Generated
    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Generated
    public void setClassPackage(String classPackage) {
        this.classPackage = classPackage;
    }

    @Generated
    public void setMethods(HashMap<String, MethodSignature> methods) {
        this.methods = methods;
    }

    @Generated
    public void setLines(ArrayList<LineSignature> lines) {
        this.lines = lines;
    }

    @Generated
    public void setTestClass(boolean testClass) {
        this.testClass = testClass;
    }

    @Generated
    public void setAccess(int access) {
        this.access = access;
    }

    @Generated
    public void setSuperName(String superName) {
        this.superName = superName;
    }

    @Generated
    public void setAnnotations(List<AnnotationInfo> annotations) {
        this.annotations = annotations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassSignature)) {
            return false;
        }
        ClassSignature other = (ClassSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
            return false;
        }
        String this$sourceFile = this.getSourceFile();
        String other$sourceFile = other.getSourceFile();
        if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
            return false;
        }
        String this$classPackage = this.getClassPackage();
        String other$classPackage = other.getClassPackage();
        if (this$classPackage == null ? other$classPackage != null : !this$classPackage.equals(other$classPackage)) {
            return false;
        }
        List<MethodSignature> this$methods = this.getMethods();
        List<MethodSignature> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        ArrayList<LineSignature> this$lines = this.getLines();
        ArrayList<LineSignature> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        if (this.isTestClass() != other.isTestClass()) {
            return false;
        }
        if (this.getAccess() != other.getAccess()) {
            return false;
        }
        String this$superName = this.getSuperName();
        String other$superName = other.getSuperName();
        if (this$superName == null ? other$superName != null : !this$superName.equals(other$superName)) {
            return false;
        }
        List<String> this$interfaces = this.getInterfaces();
        List<String> other$interfaces = other.getInterfaces();
        if (this$interfaces == null ? other$interfaces != null : !((Object)this$interfaces).equals(other$interfaces)) {
            return false;
        }
        List<AnnotationInfo> this$annotations = this.getAnnotations();
        List<AnnotationInfo> other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        String $sourceFile = this.getSourceFile();
        result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
        String $classPackage = this.getClassPackage();
        result = result * 59 + ($classPackage == null ? 43 : $classPackage.hashCode());
        List<MethodSignature> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        ArrayList<LineSignature> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        result = result * 59 + (this.isTestClass() ? 79 : 97);
        result = result * 59 + this.getAccess();
        String $superName = this.getSuperName();
        result = result * 59 + ($superName == null ? 43 : $superName.hashCode());
        List<String> $interfaces = this.getInterfaces();
        result = result * 59 + ($interfaces == null ? 43 : ((Object)$interfaces).hashCode());
        List<AnnotationInfo> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    @Generated
    public ClassSignature() {
    }
}

