/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.classloader;

import io.sealights.onpremise.agents.commons.instrument.classloader.ClassLoaderTransformer;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassLoaderPrinter;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassNameConverter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

class LoadClassMethodVisitor
extends AdviceAdapter {
    public static String LOAD_CLASS_METHOD = "loadClass";
    public static String LOAD_CLASS_DESC_1 = "(Ljava/lang/String;)Ljava/lang/Class;";
    public static String LOAD_CLASS_DESC_2 = "(Ljava/lang/String;Z)Ljava/lang/Class;";
    private final boolean needsStackMapFrames;
    private final String className;
    private boolean loadByNameOnly = false;

    protected LoadClassMethodVisitor(MethodVisitor mv, int access, String name, String desc, String className, boolean needsStackMapFrames, ClassLoader classLoader) {
        super(589824, mv, access, name, desc);
        this.needsStackMapFrames = needsStackMapFrames;
        ClassLoaderTransformer.LOG.info("Visiting class '{}', method:'{}', desc:'{}', {}", className, name, desc, ClassLoaderPrinter.toString(classLoader));
        if (LOAD_CLASS_DESC_1.equals(desc)) {
            this.loadByNameOnly = true;
        }
        this.className = className;
    }

    @Override
    protected void onMethodEnter() {
        this.visitVarInsn(25, 1);
        this.visitLdcInsn("io.sealights.");
        this.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
        Label notASealightsClass = new Label();
        this.visitJumpInsn(153, notASealightsClass);
        this.visitVarInsn(25, 1);
        this.visitInsn(3);
        this.visitInsn(1);
        this.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", false);
        this.visitInsn(176);
        this.visitLabel(notASealightsClass);
        if (this.needsStackMapFrames) {
            if (this.loadByNameOnly) {
                this.defineFrameForLoadByNameOnly();
            } else {
                this.defineFrameForLoadByNameAndFlag();
            }
        }
    }

    private void defineFrameForLoadByNameOnly() {
        this.visitFrame(-1, 2, new Object[]{ClassNameConverter.classToBinaryName(this.className), Type.getInternalName(String.class)}, 0, new Object[0]);
    }

    private void defineFrameForLoadByNameAndFlag() {
        this.visitFrame(-1, 3, new Object[]{ClassNameConverter.classToBinaryName(this.className), Type.getInternalName(String.class), Opcodes.INTEGER}, 0, new Object[0]);
    }

    @Override
    public void visitMaxs(int stack, int variables) {
        super.visitMaxs(Math.max(stack, 3), variables);
    }
}

