/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.classloader;

import io.sealights.onpremise.agents.commons.instrument.classloader.ClassLoaderClassMatcher;
import io.sealights.onpremise.agents.commons.instrument.classloader.ClassLoaderClassVisitor;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassLoaderPrinter;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;

public class ClassLoaderTransformer
implements ClassFileTransformer {
    static Logger LOG = LogFactory.getLogger(ClassLoaderTransformer.class);
    private final ClassLoaderClassMatcher classLoaderMatcher;

    public ClassLoaderTransformer() {
        this.classLoaderMatcher = new ClassLoaderClassMatcher();
    }

    public ClassLoaderTransformer(String classLoadersExcluded) {
        this.classLoaderMatcher = new ClassLoaderClassMatcher(classLoadersExcluded);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined != null) {
            LOG.debug("Ignored already loaded class (classBeingRedefined not null): '{}', {}", (Object)className, (Object)ClassLoaderPrinter.toString(loader));
            return null;
        }
        try {
            if (this.classLoaderMatcher.shouldWeave(className)) {
                LOG.trace("Try instrument class '{}', {}", (Object)className, (Object)ClassLoaderPrinter.toString(loader));
                ClassReader reader = new ClassReader(classfileBuffer);
                ClassWriter cw = new ClassWriter(reader, 0);
                ClassLoaderClassVisitor vstr = new ClassLoaderClassVisitor(cw, className.replace("/", "."), loader);
                reader.accept(vstr, 8);
                if (vstr.isInstrumented()) {
                    LOG.info("Instrumented class '{}', {}", (Object)className, (Object)ClassLoaderPrinter.toString(loader));
                    return cw.toByteArray();
                }
                return null;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to instrument class '{}', {}", className, ClassLoaderPrinter.toString(loader), e);
        }
        return null;
    }
}

