/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.classloader;

import io.sealights.onpremise.agents.commons.instrument.classloader.LoadClassMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ClassLoaderClassVisitor
extends ClassVisitor {
    private final String className;
    private boolean needsStackMapFrames = false;
    private final ClassLoader classLoader;
    private boolean instrumented = false;

    public ClassLoaderClassVisitor(ClassVisitor cv, String className, ClassLoader classLoader) {
        super(589824, cv);
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (version >= 50) {
            this.needsStackMapFrames = true;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor defaultVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (!this.isStaticMethod(access) && name.equals(LoadClassMethodVisitor.LOAD_CLASS_METHOD) && (LoadClassMethodVisitor.LOAD_CLASS_DESC_1.equals(desc) || LoadClassMethodVisitor.LOAD_CLASS_DESC_2.equals(desc))) {
            this.instrumented = true;
            return new LoadClassMethodVisitor(defaultVisitor, access, name, desc, this.className, this.needsStackMapFrames, this.classLoader);
        }
        return defaultVisitor;
    }

    public boolean isInstrumented() {
        return this.instrumented;
    }

    private boolean isStaticMethod(int access) {
        return (access & 8) == 8;
    }
}

