/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.classloader;

import io.sealights.onpremise.agents.commons.instrument.visitors.ClassVisitorHelper;
import io.sealights.onpremise.agents.infra.filters.WildcardPattern;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class ClassLoaderClassMatcher {
    public static final String[] PREDEFINED_CLASS_LOADERS = new String[]{"java/lang/ClassLoader", "java/security/SecureClassLoader", "java/net/URLClassLoader", "java/net/URLClassLoader/FactoryURLClassLoader"};
    private static final String DEFAULT_CLASS_LOADER_EXCLUDES = "sun.reflect*, com.sun*, com.sun.proxy*, javax.management*, java.lang*, java.net*, org.apache.maven.surefire.*, net.bytebuddy.*, org.springframework.*, io.opentelemetry.*, ";
    private final WildcardPattern excludesFilter;

    public ClassLoaderClassMatcher() {
        this.excludesFilter = new WildcardPattern("sun.reflect*, com.sun*, com.sun.proxy*, javax.management*, java.lang*, java.net*, org.apache.maven.surefire.*, net.bytebuddy.*, org.springframework.*, io.opentelemetry.*, *FastClassByGuice*, *ByCGLIB*, *WithCGLIB*, *EnhancerBySpringCGLIB*, *FastClassBySpringCGLIB*, *MockitoMock*");
    }

    public ClassLoaderClassMatcher(String additionalClassLoadersExcluded) {
        String classLoadersExcluded = "sun.reflect*, com.sun*, com.sun.proxy*, javax.management*, java.lang*, java.net*, org.apache.maven.surefire.*, net.bytebuddy.*, org.springframework.*, io.opentelemetry.*, *FastClassByGuice*, *ByCGLIB*, *WithCGLIB*, *EnhancerBySpringCGLIB*, *FastClassBySpringCGLIB*, *MockitoMock*" + (StringUtils.isNotEmpty(additionalClassLoadersExcluded) ? ", " + additionalClassLoadersExcluded : "");
        this.excludesFilter = new WildcardPattern(classLoadersExcluded);
    }

    public boolean shouldWeave(String className) {
        return !this.excludesFilter.matches(className) && !this.isPredefinedClassLoader(ClassVisitorHelper.dotToSlash(className));
    }

    private boolean isPredefinedClassLoader(String className) {
        for (String cl : PREDEFINED_CLASS_LOADERS) {
            if (!className.equals(cl)) continue;
            return true;
        }
        return false;
    }
}

