/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.classloader;

import io.sealights.onpremise.agents.commons.instrument.utils.ClassLoaderPrinter;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;

public final class ClassLoadUtils {
    private static Logger LOG = LogFactory.getLogger(ClassLoadUtils.class);
    private static final String DOT_CLASS = ".class";

    public static Class<?> defineClass(byte[] bytecode) throws IOException {
        return new TestClassLoader().defineClass(bytecode);
    }

    public static Class<?> defineClass(byte[] bytecode, ClassLoader parentLoader) throws IOException {
        return new TestClassLoader(parentLoader).defineClass(bytecode);
    }

    public static ClassReader createClassReader(ClassLoader classLoader, String className) throws Exception {
        try (InputStream in = null;){
            if (classLoader != null && (in = classLoader.getResourceAsStream(className + DOT_CLASS)) != null) {
                ClassReader classReader = new ClassReader(in);
                return classReader;
            }
            ClassReader classReader = new ClassReader(className);
            return classReader;
        }
    }

    public static byte[] getClassBytecode(String className) throws ClassNotFoundException {
        block5: {
            byte[] clsBytecode;
            InputStream stream;
            block4: {
                byte[] byArray;
                stream = null;
                clsBytecode = null;
                try {
                    stream = ClassLoadUtils.class.getResourceAsStream(className + DOT_CLASS);
                    clsBytecode = ClassLoadUtils.readByteCode(stream);
                    if (clsBytecode == null) break block4;
                    byArray = clsBytecode;
                }
                catch (Throwable throwable) {
                    ClassLoadUtils.tryClose(stream);
                    throw throwable;
                }
                ClassLoadUtils.tryClose(stream);
                return byArray;
            }
            stream = ClassLoader.getSystemResourceAsStream(className + DOT_CLASS);
            clsBytecode = ClassLoadUtils.readByteCode(stream);
            if (clsBytecode == null) break block5;
            byte[] byArray = clsBytecode;
            ClassLoadUtils.tryClose(stream);
            return byArray;
        }
        LOG.error("Failed to read class '{}'", (Object)className);
        throw new ClassNotFoundException(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] readByteCode(InputStream stream) {
        byte[] clsBytecode = null;
        DataInputStream in = null;
        if (stream != null) {
            try {
                int size = stream.available();
                clsBytecode = new byte[size];
                in = new DataInputStream(stream);
                in.readFully(clsBytecode);
                in.close();
            }
            catch (Exception exception) {
                ClassLoadUtils.tryClose(in);
                catch (Throwable throwable) {
                    ClassLoadUtils.tryClose(in);
                    throw throwable;
                }
            }
            ClassLoadUtils.tryClose(in);
        }
        return clsBytecode;
    }

    private static void tryClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Generated
    private ClassLoadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TestClassLoader
    extends ClassLoader {
        public TestClassLoader() {
        }

        public TestClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(byte[] bytecode) {
            return this.defineClass(null, bytecode, 0, bytecode.length);
        }
    }

    public static class ClassNotSupportedByLoaderException
    extends RuntimeException {
        public ClassNotSupportedByLoaderException(String className, ClassLoader classLoader) {
            super(String.format("class '%s' cannot be loaded by %s", className, ClassLoaderPrinter.toString(classLoader)));
        }
    }
}

