/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.annotations;

import io.sealights.onpremise.agents.commons.instrument.annotations.ClassAnnotationsTransformVisitor;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;

public class UpsertClassAnnotationTransformer {
    static Logger LOG = LogFactory.getLogger(UpsertClassAnnotationTransformer.class);
    private final String annotationDescriptor;
    private final String arrayFieldName;
    private final ArrayValueInsertion arrayValueInsertion;
    private int classWriterFlag = 2;
    private int classReaderFlag = 4;

    UpsertClassAnnotationTransformer(String annotationDescriptor, String arrayFieldName, ArrayValueInsertion arrayValueInsertion) {
        this.annotationDescriptor = annotationDescriptor;
        this.arrayFieldName = arrayFieldName;
        this.arrayValueInsertion = arrayValueInsertion;
    }

    public int getClassWriterFlag() {
        return this.classWriterFlag;
    }

    public void setClassWriterFlag(int classWriterFlag) {
        this.classWriterFlag = classWriterFlag;
    }

    public int getClassReaderFlag() {
        return this.classReaderFlag;
    }

    public void setClassReaderFlag(int classReaderFlag) {
        this.classReaderFlag = classReaderFlag;
    }

    public byte[] transform(byte[] originalClass) {
        ClassWriter writer = new ClassWriter(this.classWriterFlag){

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                try {
                    return super.getCommonSuperClass(type1, type2);
                }
                catch (TypeNotPresentException tnpe) {
                    LOG.warn("TypeNotPresentException in getCommonSuperClass: type1={} type2={}", (Object)type1, (Object)type2);
                    throw tnpe;
                }
            }
        };
        ClassReader classReader = new ClassReader(originalClass);
        UpsertAnnotationClassVisitor transformingVisitor = new UpsertAnnotationClassVisitor(writer, this.annotationDescriptor, this.arrayFieldName, this.arrayValueInsertion);
        classReader.accept(transformingVisitor, this.classReaderFlag);
        return writer.toByteArray();
    }

    static interface ArrayValueInsertion {
        public void insert(ModifyingArrayVisitor var1);
    }

    static class ModifyingArrayVisitor
    extends AnnotationVisitor {
        private final ArrayValueInsertion arrayValueInsertion;

        public ModifyingArrayVisitor(ArrayValueInsertion arrayValueInsertion, AnnotationVisitor annotationVisitor) {
            super(589824, annotationVisitor);
            this.arrayValueInsertion = arrayValueInsertion;
            this.av = annotationVisitor;
        }

        @Override
        public void visitEnd() {
            this.arrayValueInsertion.insert(this);
            this.av.visitEnd();
        }
    }

    static class ModifyingAnnotationVisitor
    extends AnnotationVisitor {
        private final String arrayFieldName;
        private final ArrayValueInsertion insertion;
        private boolean targetArrayVisited = false;

        public ModifyingAnnotationVisitor(String arrayFieldName, ArrayValueInsertion insertion, AnnotationVisitor av) {
            super(589824, av);
            this.arrayFieldName = arrayFieldName;
            this.insertion = insertion;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (this.arrayFieldName.equals(name)) {
                this.targetArrayVisited = true;
                return new ModifyingArrayVisitor(this.insertion, this.av.visitArray(name));
            }
            return this.av.visitArray(name);
        }

        @Override
        public void visitEnd() {
            if (!this.targetArrayVisited) {
                AnnotationVisitor annotationVisitor = this.visitArray(this.arrayFieldName);
                annotationVisitor.visitEnd();
            }
            this.av.visitEnd();
        }
    }

    static class UpsertAnnotationClassVisitor
    extends ClassAnnotationsTransformVisitor {
        private final String annotationDescriptor;
        private final String arrayFieldName;
        private final ArrayValueInsertion valueInsertion;
        private boolean updated = false;

        protected UpsertAnnotationClassVisitor(ClassVisitor cv, String annotationDescriptor, String arrayFieldName, ArrayValueInsertion valueInsertion) {
            super(cv);
            this.annotationDescriptor = annotationDescriptor;
            this.arrayFieldName = arrayFieldName;
            this.valueInsertion = valueInsertion;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals(this.annotationDescriptor)) {
                this.updated = true;
                return new ModifyingAnnotationVisitor(this.arrayFieldName, this.valueInsertion, this.cv.visitAnnotation(descriptor, visible));
            }
            return this.cv.visitAnnotation(descriptor, visible);
        }

        @Override
        protected void transformAnnotations() {
            if (!this.updated) {
                AnnotationVisitor annotationVisitor = this.visitAnnotation(this.annotationDescriptor, true);
                AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(this.arrayFieldName);
                arrayVisitor.visitEnd();
                LOG.debug("Value '{}' was added into annotation field '{}'", (Object)this.annotationDescriptor, (Object)this.arrayFieldName);
            }
        }
    }
}

