/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.annotations;

import io.sealights.onpremise.agents.commons.instrument.annotations.UpsertClassAnnotationTransformer;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public class UpsertClassAnnotation {
    static Logger LOG = LogFactory.getLogger(UpsertClassAnnotation.class);

    public static UpsertClassAnnotationTransformer createTransformerForAddingObjectToArray(Class<? extends Annotation> annotation, String arrayFieldName, final Class<?> newElement) {
        UpsertClassAnnotationTransformer.ArrayValueInsertion valueInsertion = new UpsertClassAnnotationTransformer.ArrayValueInsertion(){

            @Override
            public void insert(UpsertClassAnnotationTransformer.ModifyingArrayVisitor visitor) {
                visitor.visit(null, Type.getType(newElement));
            }
        };
        return UpsertClassAnnotation.verifyAndCreate(annotation, arrayFieldName, newElement, valueInsertion);
    }

    public static UpsertClassAnnotationTransformer createTransformerForAddingStringToArray(Class<? extends Annotation> annotation, String arrayFieldName, final String newElement) {
        UpsertClassAnnotationTransformer.ArrayValueInsertion valueInsertion = new UpsertClassAnnotationTransformer.ArrayValueInsertion(){

            @Override
            public void insert(UpsertClassAnnotationTransformer.ModifyingArrayVisitor visitor) {
                visitor.visit(null, newElement);
            }
        };
        return UpsertClassAnnotation.verifyAndCreate(annotation, arrayFieldName, newElement, valueInsertion);
    }

    public static UpsertClassAnnotationTransformer createTransformerForAddingObjectToArray(String className, String annotationDescriptor, String arrayFieldName, final String newElementTypeDescriptor) {
        LOG.info("Upserting annotation '{}' at class '{}': adding '{}' to '{}'", Type.getType(annotationDescriptor), className, Type.getType(newElementTypeDescriptor), arrayFieldName);
        UpsertClassAnnotationTransformer.ArrayValueInsertion valueInsertion = new UpsertClassAnnotationTransformer.ArrayValueInsertion(){

            @Override
            public void insert(UpsertClassAnnotationTransformer.ModifyingArrayVisitor visitor) {
                visitor.visit(null, Type.getType(newElementTypeDescriptor));
            }
        };
        return new UpsertClassAnnotationTransformer(annotationDescriptor, arrayFieldName, valueInsertion);
    }

    private static UpsertClassAnnotationTransformer verifyAndCreate(Class<? extends Annotation> annotation, String arrayFieldName, Object newElement, UpsertClassAnnotationTransformer.ArrayValueInsertion modification) {
        LOG.debug("Upserting annotation '{}': adding element '{}' to field:'{}'", annotation.getName(), newElement.getClass().getName(), arrayFieldName);
        UpsertClassAnnotation.verifyFieldAndType(annotation, arrayFieldName, newElement);
        return new UpsertClassAnnotationTransformer(Type.getDescriptor(annotation), arrayFieldName, modification);
    }

    private static void verifyFieldAndType(Class<? extends Annotation> annotation, String arrayFieldName, Object newElement) {
        try {
            Method method = annotation.getMethod(arrayFieldName, new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (!returnType.isArray()) {
                UpsertClassAnnotation.reportError(String.format("verification failed: '%s.%s' is not an array", annotation.getName(), arrayFieldName), null);
            }
            Class<?> componentType = returnType.getComponentType();
            if (!newElement.getClass().isAssignableFrom(componentType)) {
                UpsertClassAnnotation.reportError(String.format("verification failed: '%s.%s' is %s[], not %s[]", annotation.getName(), arrayFieldName, componentType.getSimpleName(), newElement.getClass().getSimpleName()), null);
            }
        }
        catch (NoSuchMethodException e) {
            UpsertClassAnnotation.reportError(String.format("annotation interface '%s' doesn't have method '%s'", annotation.getName(), arrayFieldName), e);
        }
    }

    private static void reportError(String error, Exception e) {
        String errorMsg = String.format("Failed to upsert annotation - %s", error);
        AgentLifeCycle.notifyErrorMsg(errorMsg);
        throw new IllegalArgumentException(errorMsg, e);
    }
}

