/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.annotations;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public abstract class ClassAnnotationsTransformVisitor
extends ClassVisitor {
    private boolean annotationsVisitFirstTime = true;

    protected ClassAnnotationsTransformVisitor(ClassVisitor classVisitor) {
        super(589824, classVisitor);
    }

    protected abstract void transformAnnotations();

    @Override
    public void visitNestMember(String nestMember) {
        this.visitAnnotationsOnce();
        this.cv.visitNestMember(nestMember);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.visitAnnotationsOnce();
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.visitAnnotationsOnce();
        return this.cv.visitField(access, name, descriptor, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.visitAnnotationsOnce();
        return this.cv.visitMethod(access, name, descriptor, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        this.visitAnnotationsOnce();
        this.cv.visitEnd();
    }

    private void visitAnnotationsOnce() {
        if (this.annotationsVisitFirstTime) {
            this.transformAnnotations();
            this.annotationsVisitFirstTime = false;
        }
    }
}

