/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.functions;

import java.util.ArrayList;
import java.util.List;

public abstract class FunctionsChain<T extends FunctionsChain<T>> {
    List<T> chainedFunctions;

    public T add(T functionToAdd) {
        T combinedFunctionsChain = this.createConcreteInstance();
        List<T> localFunctionsChain = this.chainedFunctions;
        if (localFunctionsChain == null) {
            ((FunctionsChain)combinedFunctionsChain).chainedFunctions = new ArrayList<T>();
            ((FunctionsChain)combinedFunctionsChain).chainedFunctions.add(this);
        } else {
            ((FunctionsChain)combinedFunctionsChain).chainedFunctions = localFunctionsChain;
        }
        if (((FunctionsChain)functionToAdd).chainedFunctions != null) {
            for (FunctionsChain function : ((FunctionsChain)functionToAdd).chainedFunctions) {
                ((FunctionsChain)combinedFunctionsChain).chainedFunctions.add(function);
            }
        } else {
            ((FunctionsChain)combinedFunctionsChain).chainedFunctions.add(functionToAdd);
        }
        return combinedFunctionsChain;
    }

    public T remove(T functionToRemove) {
        if (this.chainedFunctions == null) {
            if (functionToRemove == this) {
                return null;
            }
            return (T)this;
        }
        List chainedFunctionAfterRemove = (List)((ArrayList)this.chainedFunctions).clone();
        if (((FunctionsChain)functionToRemove).chainedFunctions != null) {
            chainedFunctionAfterRemove.removeAll(((FunctionsChain)functionToRemove).chainedFunctions);
        } else {
            chainedFunctionAfterRemove.remove(functionToRemove);
        }
        if (chainedFunctionAfterRemove.size() == 1) {
            return (T)((FunctionsChain)chainedFunctionAfterRemove.get(0));
        }
        if (chainedFunctionAfterRemove.size() == 0) {
            return null;
        }
        T concreteFunctionChain = this.createConcreteInstance();
        ((FunctionsChain)concreteFunctionChain).chainedFunctions = chainedFunctionAfterRemove;
        return concreteFunctionChain;
    }

    public static <T extends FunctionsChain<T>> T combine(T func1, T func2) {
        if (func1 == null) {
            return func2;
        }
        if (func2 == null) {
            return func1;
        }
        return func1.add(func2);
    }

    public static <T extends FunctionsChain<T>> T remove(T funcChainToRemoveFrom, T funcChainToRemove) {
        if (funcChainToRemoveFrom == null) {
            return funcChainToRemove;
        }
        if (funcChainToRemove == null) {
            return funcChainToRemoveFrom;
        }
        return funcChainToRemoveFrom.remove(funcChainToRemove);
    }

    protected abstract T createConcreteInstance();
}

