/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.footprints;

import io.sealights.onpremise.agents.commons.footprints.MethFootprint;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class MethFootprintsContainer<T extends MethFootprint> {
    private static Logger LOG = LogFactory.getLogger(MethFootprintsContainer.class);
    private int[] methodHitsArray = new int[this.availableMethodSlots];
    private T[] methodFootprintArray = this.allocateFootprintsArray(this.availableMethodSlots);
    private int totalRegisteredMethods = 0;
    private int availableMethodSlots = 102400;
    public static final int METHOD_HITS_INITIAL_SIZE = 102400;
    public static final int GROW_FACTOR = 2;

    protected abstract T[] allocateFootprintsArray(int var1);

    public synchronized List<T> flushFootprints() {
        ArrayList footprints = new ArrayList();
        for (int index = 0; index <= this.totalRegisteredMethods; ++index) {
            int hitCounter = this.methodHitsArray[index];
            this.methodHitsArray[index] = 0;
            if (hitCounter <= 0) continue;
            Object methodFootrpint = ((MethFootprint)this.methodFootprintArray[index]).clone(hitCounter);
            footprints.add(methodFootrpint);
        }
        LOG.debug("Footprints with hits: {}", (Object)LogLevelToStringFormatter.toString(Level.DEBUG, footprints));
        return footprints;
    }

    public synchronized int addMethod(T methodFootprint) {
        this.incTotalRegisteredMethods();
        this.resizeIfFull();
        int methodIndex = this.totalRegisteredMethods - 1;
        this.methodHitsArray[methodIndex] = ((MethFootprint)methodFootprint).getHitCounter();
        this.methodFootprintArray[methodIndex] = methodFootprint;
        return methodIndex;
    }

    public void reportMethodHit(int methodIndex) {
        this.methodHitsArray[methodIndex] = this.methodHitsArray[methodIndex] + 1;
        LOG.trace("reportedMethodHit for methodIndex={}: updated hitCounter={},", (Object)methodIndex, (Object)this.methodHitsArray[methodIndex]);
    }

    private void resizeIfFull() {
        if (this.totalRegisteredMethods == this.availableMethodSlots) {
            int newSize = this.availableMethodSlots * 2;
            int[] newMethodHitsArray = new int[newSize];
            System.arraycopy(this.methodHitsArray, 0, newMethodHitsArray, 0, this.availableMethodSlots);
            MethFootprint[] newMethodDataArray = this.allocateFootprintsArray(newSize);
            System.arraycopy(this.methodFootprintArray, 0, newMethodDataArray, 0, this.availableMethodSlots);
            this.methodHitsArray = newMethodHitsArray;
            this.methodFootprintArray = newMethodDataArray;
            this.availableMethodSlots = newSize;
        }
    }

    private void incTotalRegisteredMethods() {
        ++this.totalRegisteredMethods;
    }

    public String toString() {
        return String.format("PLFootprintsContainer:%n\ttotalRegisteredMethods=%s, %n\tavailableMethodSlots=%s, %n\tmethodHits/footprints:%n%s", this.totalRegisteredMethods, this.availableMethodSlots, this.toStringArrays());
    }

    private String toStringArrays() {
        StringBuilder buf = new StringBuilder();
        if (this.totalRegisteredMethods == 0) {
            buf.append("empty");
        } else {
            for (int i = 0; i < this.totalRegisteredMethods; ++i) {
                buf.append(String.format("\t[%4s]: hits(%s), footprint(%s)", i, this.methodHitsArray[i], this.methodFootprintArray[i]));
                if (i >= this.totalRegisteredMethods - 1) continue;
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    @Generated
    public int[] getMethodHitsArray() {
        return this.methodHitsArray;
    }

    @Generated
    public T[] getMethodFootprintArray() {
        return this.methodFootprintArray;
    }

    @Generated
    public int getTotalRegisteredMethods() {
        return this.totalRegisteredMethods;
    }
}

