/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.footprints;

import io.sealights.onpremise.agents.commons.footprints.MethFootprint;
import io.sealights.onpremise.agents.commons.footprints.MethFootprintsContainer;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.List;
import org.slf4j.Logger;

public abstract class MethFootprintsCollector<T extends MethFootprintsContainer<D>, D extends MethFootprint> {
    private static Logger LOG = LogFactory.getLogger(MethFootprintsCollector.class);
    protected T footprintsContainer = this.createFootprintContainer();

    public List<D> flushFootprints() {
        return ((MethFootprintsContainer)this.footprintsContainer).flushFootprints();
    }

    public int addMethod(D methodData) {
        LOG.debug("Adding method {}", (Object)methodData);
        return ((MethFootprintsContainer)this.footprintsContainer).addMethod(methodData);
    }

    public D[] getAllFootprints() {
        return this.footprintsContainer.getMethodFootprintArray();
    }

    public void applyMethodHit(int methodId) {
        ((MethFootprintsContainer)this.footprintsContainer).reportMethodHit(methodId);
    }

    protected static void handleHitException(Exception e, String hitName) {
        if (e instanceof NullPointerException) {
            MethFootprintsCollector.handleHitNullPointerException((NullPointerException)e, hitName);
            return;
        }
        LOG.error("Failed to report " + hitName + " hit. Error: ", e);
    }

    protected static void handleHitNullPointerException(NullPointerException e, String hitName) {
        ClassLoader classLoader = MethFootprintsCollector.class.getClassLoader();
        LOG.error("Failed to report " + hitName + " hit due to null pointer exception. It might be due to different class loader. Class Loader: '{}' Error: ", (Object)classLoader, (Object)e);
    }

    protected abstract T createFootprintContainer();
}

