/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles.tomcat;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFileParser {
    protected String filename;
    private Document document;

    public XmlFileParser(String filename) {
        this.filename = filename;
    }

    public Document parse() throws Exception {
        if (this.document != null) {
            return this.document;
        }
        this.document = this.getDocumentInternal();
        return this.document;
    }

    protected Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    protected Document getDocumentInternal() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(this.filename);
        return doc;
    }

    protected NodeList getNodeList(String xpath, Element parent) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression expression = xPath.compile(xpath);
        return (NodeList)expression.evaluate(parent, XPathConstants.NODESET);
    }

    public List<Element> getElements(String xpath, Element parent) throws XPathExpressionException {
        NodeList nodes = this.getNodeList(xpath, parent);
        ArrayList<Element> childElements = new ArrayList<Element>();
        childElements.addAll(this.toElementList(nodes));
        return childElements;
    }

    public boolean isNodeExist(String xpath, Element parent) throws XPathExpressionException {
        NodeList nodes = this.getNodeList(xpath, parent);
        return nodes.getLength() > 0;
    }

    protected List<Element> toElementList(NodeList nodes) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add((Element)node);
        }
        return childElements;
    }

    protected List<Element> getChildrenElements(Element parent) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childrenNodeList = parent.getChildNodes();
        children.addAll(this.toElementList(childrenNodeList));
        return children;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public Document getDocument() {
        return this.document;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setDocument(Document document) {
        this.document = document;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmlFileParser)) {
            return false;
        }
        XmlFileParser other = (XmlFileParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof XmlFileParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "XmlFileParser(filename=" + this.getFilename() + ", document=" + this.getDocument() + ")";
    }
}

