/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles.tomcat;

import io.sealights.onpremise.agents.commons.defaultfiles.tomcat.ServerXmlParser;
import io.sealights.onpremise.agents.commons.defaultfiles.tomcat.TomcatConfiguration;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import java.util.ArrayList;
import java.util.List;

public class TomcatWebappPathDetector {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private List<String> webappPathValues = new ArrayList<String>();
    private ServerXmlParser serverXmlParser;
    private String catalinaBase = TomcatConfiguration.getCatalinaBase();

    public TomcatWebappPathDetector() {
        this.serverXmlParser = new ServerXmlParser(this.catalinaBase);
    }

    public List<String> detect() {
        try {
            CONSOLE_LOG.info("{}={}, {}={}", "catalina.base", this.catalinaBase, "catalina.home", TomcatConfiguration.getCatalinaHome());
            this.webappPathValues.addAll(this.serverXmlParser.collectAppBaseValues());
            this.logDetectedValues();
        }
        catch (Exception e) {
            String defaultLocation = PathUtils.join(this.catalinaBase, "webapps");
            this.webappPathValues.add(FileAndFolderUtils.resolveAbsolutePath(defaultLocation));
            CONSOLE_LOG.warn("Failed to read 'server.xml' file, using the default tomcat war location '{}'", (Object)this.webappPathValues.get(0), (Object)e);
        }
        return this.webappPathValues;
    }

    private void logDetectedValues() {
        switch (this.webappPathValues.size()) {
            case 0: {
                CONSOLE_LOG.info("no webapp value was detected");
                break;
            }
            case 1: {
                CONSOLE_LOG.info("detected webapp value={}", (Object)this.webappPathValues.get(0));
                break;
            }
            default: {
                CONSOLE_LOG.info("detected webapp values:{}", (Object)this.webappPathValues);
            }
        }
    }
}

