/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles.tomcat;

import io.sealights.onpremise.agents.infra.env.OsDetector;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import lombok.Generated;

public final class TomcatConfiguration {
    public static final String CATALINA_BASE = "catalina.base";
    public static final String CATALINA_HOME = "catalina.home";
    public static final String DEFAULT_TOMCAT_WAR_LOCATION = "webapps";
    public static final String CATALINA_BASE_WIN = TomcatConfiguration.asWindowsPlaceholder("catalina.base");
    public static final String CATALINA_HOME_WIN = TomcatConfiguration.asWindowsPlaceholder("catalina.home");
    public static final String CATALINA_BASE_LINUX = TomcatConfiguration.asLinuxPlaceholder("catalina.base");
    public static final String CATALINA_HOME_LINUX = TomcatConfiguration.asLinuxPlaceholder("catalina.home");
    private static final String CONF = "conf";
    private static final String SERVER_XML = "server.xml";

    public static String getCatalinaBase() {
        return System.getProperty(CATALINA_BASE, "");
    }

    public static String getCatalinaHome() {
        return System.getProperty(CATALINA_HOME, "");
    }

    public static String getServerXmlPath(String root) {
        return PathUtils.join(root, CONF, SERVER_XML);
    }

    private static String asWindowsPlaceholder(String propName) {
        return String.format("%%%s%%", propName);
    }

    public static String replaceCatalinaPlaceholder(String pathValue) {
        String replaced = pathValue;
        if (pathValue.contains(CATALINA_BASE)) {
            replaced = TomcatConfiguration.replacePropertyPlaceholderByOs(CATALINA_BASE_WIN, CATALINA_BASE_LINUX, TomcatConfiguration.getCatalinaBase(), pathValue);
        } else if (pathValue.contains(CATALINA_HOME)) {
            replaced = TomcatConfiguration.replacePropertyPlaceholderByOs(CATALINA_HOME_WIN, CATALINA_HOME_LINUX, TomcatConfiguration.getCatalinaHome(), pathValue);
        }
        return replaced;
    }

    private static String replacePropertyPlaceholderByOs(String windowPattern, String linuxPattern, String replacement, String origValue) {
        if (OsDetector.isWindows()) {
            return origValue.replace(windowPattern, replacement);
        }
        return origValue.replace(linuxPattern, replacement);
    }

    private static String asLinuxPlaceholder(String propName) {
        return String.format("${%s}", propName);
    }

    @Generated
    private TomcatConfiguration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

