/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles.tomcat;

import io.sealights.onpremise.agents.commons.defaultfiles.tomcat.DistinctPathCollector;
import io.sealights.onpremise.agents.commons.defaultfiles.tomcat.TomcatConfiguration;
import io.sealights.onpremise.agents.commons.defaultfiles.tomcat.XmlFileParser;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerXmlParser
extends XmlFileParser {
    private static Logger LOG = LogFactory.getLogger(ServerXmlParser.class);
    public static final String HOST = "Host";
    public static final String APP_BASE = "appBase";
    private DistinctPathCollector appBaseCollector = new DistinctPathCollector();

    public ServerXmlParser(String root) {
        super(TomcatConfiguration.getServerXmlPath(root));
    }

    public List<String> collectAppBaseValues() throws Exception {
        this.parse();
        List<Element> hosts = this.getNodes(HOST);
        for (Element host : hosts) {
            String appBase = host.getAttribute(APP_BASE);
            if (!StringUtils.isNotEmpty(appBase)) continue;
            this.appBaseCollector.add(appBase);
        }
        LOG.info("Collected " + this.appBaseCollector.getValues());
        return this.appBaseCollector.getValues();
    }

    private List<Element> getNodes(String tag) {
        Element root = this.getDocumentElement();
        NodeList nodes = root.getElementsByTagName(tag);
        LOG.info("found {} elements of '{}'", (Object)nodes.getLength(), (Object)tag);
        return this.toElementList(nodes);
    }
}

