/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles.tomcat;

import io.sealights.onpremise.agents.commons.defaultfiles.tomcat.TomcatConfiguration;
import io.sealights.onpremise.agents.infra.env.OsDetector;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class DistinctPathCollector {
    private static Logger LOG = LogFactory.getLogger(DistinctPathCollector.class);
    private Set<String> values = new HashSet<String>();

    public void add(String appBase) {
        String newPath = FileAndFolderUtils.resolveAbsolutePath(appBase = TomcatConfiguration.replaceCatalinaPlaceholder(appBase));
        if (newPath != null && this.values.contains(newPath)) {
            return;
        }
        if (this.values.isEmpty()) {
            this.values.add(newPath);
        } else {
            this.normalizeOrAdd(newPath);
        }
    }

    public List<String> getValues() {
        return new ArrayList<String>(this.values);
    }

    private void normalizeOrAdd(String newPath) {
        boolean commonRootFound = false;
        for (String val : this.values) {
            String commonRoot = this.resolveCommonRoot(val, newPath);
            if (commonRoot.isEmpty()) continue;
            if (!val.equals(commonRoot)) {
                this.values.remove(val);
                this.values.add(commonRoot);
                LOG.info("path '{}' was replaced by common root '{}'; '{}' was not added", val, commonRoot, newPath);
            }
            commonRootFound = true;
        }
        if (!commonRootFound) {
            this.values.add(newPath);
        }
    }

    private String resolveCommonRoot(String left, String right) {
        String[] rightSegments;
        String[] leftSegments = left.split(Pattern.quote(File.separator));
        int scanSize = leftSegments.length;
        if (scanSize > (rightSegments = right.split(Pattern.quote(File.separator))).length) {
            scanSize = rightSegments.length;
        }
        ArrayList<String> commonRootSegments = new ArrayList<String>();
        for (int i = 0; i < scanSize && leftSegments[i].equals(rightSegments[i]); ++i) {
            commonRootSegments.add(leftSegments[i]);
        }
        if (!commonRootSegments.isEmpty() && !this.isWindowsDriveRoot(commonRootSegments)) {
            return PathUtils.join(commonRootSegments);
        }
        return "";
    }

    private boolean isWindowsDriveRoot(List<String> commonRootSegments) {
        return OsDetector.isWindows() && commonRootSegments.size() == 1;
    }
}

