/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles;

import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class WebAppSettings {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    public static final String JBOSS_DEFAULT_WEBAPP_LOCTAION = "standalone" + File.separator + "deployments";
    private String webappLocationPropValue;
    private List<String> tomcatWebappLocations;
    private boolean runningOnTomcat = false;

    public void addLocation(String value) {
        if (this.tomcatWebappLocations == null) {
            this.tomcatWebappLocations = new ArrayList<String>();
        }
        this.tomcatWebappLocations.add(value);
    }

    public void initJbossLocation() {
        if (StringUtils.isNullOrEmpty(this.webappLocationPropValue)) {
            this.webappLocationPropValue = PathUtils.join(DefaultDirs.WORKING_DIR, JBOSS_DEFAULT_WEBAPP_LOCTAION);
            CONSOLE_LOG.info("Using default webappLocation '{}' for JBOSS", (Object)this.webappLocationPropValue);
        } else {
            CONSOLE_LOG.info("Using provided webappLocation '{}' for JBOSS", (Object)this.webappLocationPropValue);
        }
    }

    public boolean isEmpty() {
        return StringUtils.isNullOrEmpty(this.webappLocationPropValue) && (this.tomcatWebappLocations == null || this.tomcatWebappLocations.isEmpty());
    }

    public String toString() {
        if (this.runningOnTomcat) {
            return String.format("tomcatWebappLocations=%s, webappLocation=%s", this.tomcatWebappLocations, this.webappLocationPropValue);
        }
        return String.format("webappLocation=%s", this.webappLocationPropValue);
    }

    @Generated
    public WebAppSettings() {
    }

    @Generated
    public String getWebappLocationPropValue() {
        return this.webappLocationPropValue;
    }

    @Generated
    public List<String> getTomcatWebappLocations() {
        return this.tomcatWebappLocations;
    }

    @Generated
    public boolean isRunningOnTomcat() {
        return this.runningOnTomcat;
    }

    @Generated
    public void setWebappLocationPropValue(String webappLocationPropValue) {
        this.webappLocationPropValue = webappLocationPropValue;
    }

    @Generated
    public void setTomcatWebappLocations(List<String> tomcatWebappLocations) {
        this.tomcatWebappLocations = tomcatWebappLocations;
    }

    @Generated
    public void setRunningOnTomcat(boolean runningOnTomcat) {
        this.runningOnTomcat = runningOnTomcat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebAppSettings)) {
            return false;
        }
        WebAppSettings other = (WebAppSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$webappLocationPropValue = this.getWebappLocationPropValue();
        String other$webappLocationPropValue = other.getWebappLocationPropValue();
        if (this$webappLocationPropValue == null ? other$webappLocationPropValue != null : !this$webappLocationPropValue.equals(other$webappLocationPropValue)) {
            return false;
        }
        List<String> this$tomcatWebappLocations = this.getTomcatWebappLocations();
        List<String> other$tomcatWebappLocations = other.getTomcatWebappLocations();
        if (this$tomcatWebappLocations == null ? other$tomcatWebappLocations != null : !((Object)this$tomcatWebappLocations).equals(other$tomcatWebappLocations)) {
            return false;
        }
        return this.isRunningOnTomcat() == other.isRunningOnTomcat();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebAppSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $webappLocationPropValue = this.getWebappLocationPropValue();
        result = result * 59 + ($webappLocationPropValue == null ? 43 : $webappLocationPropValue.hashCode());
        List<String> $tomcatWebappLocations = this.getTomcatWebappLocations();
        result = result * 59 + ($tomcatWebappLocations == null ? 43 : ((Object)$tomcatWebappLocations).hashCode());
        result = result * 59 + (this.isRunningOnTomcat() ? 79 : 97);
        return result;
    }
}

