/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles;

import io.sealights.onpremise.agents.commons.defaultfiles.DefaultFileResolveProcedure;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;

public final class DefaultTempFilesHandler {
    private static final Logger LOG = LogFactory.getLogger(DefaultTempFilesHandler.class);
    public static String agentInstanceUniqueFileIndicator;
    public static final String TEMP_FILE_PATHS_PROPERTY = "sl-temp-file-paths";

    public static void deleteTempFiles() {
        String[] tempFilePaths;
        String rawTempFilePaths = System.getProperty(TEMP_FILE_PATHS_PROPERTY);
        if (rawTempFilePaths == null) {
            return;
        }
        for (String tempFilePath : tempFilePaths = rawTempFilePaths.split(",")) {
            try {
                Files.deleteIfExists(Paths.get(tempFilePath, new String[0]));
            }
            catch (Exception e) {
                LOG.debug("Couldn't delete temporary file: {}", (Object)tempFilePath, (Object)e);
            }
        }
    }

    static void handleTemporaryFile(DefaultFileResolveProcedure resolver, String resolvedPath) {
        if (!resolver.isResolvedFileTemporary()) {
            return;
        }
        String rawTempFilePaths = System.getProperty(TEMP_FILE_PATHS_PROPERTY);
        if (rawTempFilePaths == null) {
            System.setProperty(TEMP_FILE_PATHS_PROPERTY, resolvedPath);
        } else {
            System.setProperty(TEMP_FILE_PATHS_PROPERTY, rawTempFilePaths + "," + resolvedPath);
        }
    }

    @Generated
    private DefaultTempFilesHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

