/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles;

import io.sealights.onpremise.agents.commons.defaultfiles.BldSessionIdFileResolveProc;
import io.sealights.onpremise.agents.commons.defaultfiles.TokenFileResolveProcedure;
import io.sealights.onpremise.agents.commons.defaultfiles.WebAppSettings;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.List;
import lombok.Generated;

public class DefaultFileResolver {
    public String resolveTokenFileLocation(WebAppSettings webAppSettings) {
        String defaultTokenFileName = null;
        defaultTokenFileName = webAppSettings.isRunningOnTomcat() ? this.resolveTokenFileOnTomcat(webAppSettings.getTomcatWebappLocations()) : (StringUtils.isNotEmpty(webAppSettings.getWebappLocationPropValue()) ? this.resolveTokenFileForWebApp(webAppSettings.getWebappLocationPropValue()) : this.resolveToken(FileAndFolderUtils.getContainingFolder()));
        if (defaultTokenFileName != null) {
            System.setProperty("sl.tokenFile", defaultTokenFileName);
        }
        return defaultTokenFileName;
    }

    public String resolveBsIdFileLocation(WebAppSettings webAppSettings) {
        String bsIdFileName = null;
        bsIdFileName = webAppSettings.isRunningOnTomcat() ? this.resolveBldSessionIdOnTomcat(webAppSettings.getTomcatWebappLocations()) : (StringUtils.isNotEmpty(webAppSettings.getWebappLocationPropValue()) ? this.resolveBldSessionIdForWebApp(webAppSettings.getWebappLocationPropValue()) : this.resolveBldSessionId(FileAndFolderUtils.getContainingFolder()));
        if (bsIdFileName != null) {
            System.setProperty("sl.buildSessionIdFile", bsIdFileName);
        }
        return bsIdFileName;
    }

    public String resolveToken(String slAgentLocation) {
        TokenFileResolveProcedure resolver = new TokenFileResolveProcedure(slAgentLocation);
        String resolvedPath = resolver.execute();
        return resolvedPath;
    }

    protected String resolveTokenFileOnTomcat(List<String> webappLocations) {
        TokenFileResolveProcedure resolver = new TokenFileResolveProcedure();
        String resolvedPath = resolver.executeOnTomcat(webappLocations);
        return resolvedPath;
    }

    protected String resolveTokenFileForWebApp(String webAppLocation) {
        TokenFileResolveProcedure resolver = new TokenFileResolveProcedure();
        String resolvedPath = resolver.executeWebApp(webAppLocation);
        return resolvedPath;
    }

    public static String resolveBldSessionId() {
        BldSessionIdFileResolveProc resolver = new BldSessionIdFileResolveProc();
        String resolvedPath = resolver.execute();
        return resolvedPath;
    }

    protected String resolveBldSessionId(String slAgentLocation) {
        BldSessionIdFileResolveProc resolver = new BldSessionIdFileResolveProc(slAgentLocation);
        String resolvedPath = resolver.execute();
        return resolvedPath;
    }

    protected String resolveBldSessionIdOnTomcat(List<String> webappLocations) {
        BldSessionIdFileResolveProc resolver = new BldSessionIdFileResolveProc();
        String resolvedPath = resolver.executeOnTomcat(webappLocations);
        return resolvedPath;
    }

    protected String resolveBldSessionIdForWebApp(String webAppLocation) {
        BldSessionIdFileResolveProc resolver = new BldSessionIdFileResolveProc();
        String resolvedPath = resolver.executeWebApp(webAppLocation);
        return resolvedPath;
    }

    @Generated
    public DefaultFileResolver() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFileResolver)) {
            return false;
        }
        DefaultFileResolver other = (DefaultFileResolver)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultFileResolver;
    }

    @Generated
    public int hashCode() {
        int result = 1;
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultFileResolver()";
    }
}

