/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.defaultfiles;

import io.sealights.onpremise.agents.commons.defaultfiles.DefaultTempFilesHandler;
import io.sealights.onpremise.agents.infra.jarutils.JarHelper;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileNameUtils;
import io.sealights.onpremise.agents.infra.utils.FilesCollector;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.jvm.JvmUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;

public class DefaultFileResolveProcedure {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    public static final String WAR = "war";
    public static final String EAR = "ear";
    public static final String JAR = "jar";
    private static final String SUFFIX_SEPARATOR = "_";
    private String resolvedFileName;
    private boolean resolvedFileTemporary;
    private String systemPropertyKey;
    private String defaultFileName;
    private JvmUtils jvmUtils;
    private final String tempFileIndicator;

    public DefaultFileResolveProcedure(String systemPropertyKey, String defaultFileName) {
        this(systemPropertyKey, defaultFileName, new JvmUtils());
    }

    protected DefaultFileResolveProcedure(String systemPropertyKey, String defaultFileName, JvmUtils jvmUtils) {
        this.systemPropertyKey = systemPropertyKey;
        this.defaultFileName = defaultFileName;
        this.tempFileIndicator = DefaultTempFilesHandler.agentInstanceUniqueFileIndicator;
        this.jvmUtils = jvmUtils;
    }

    public String execute() {
        if (this.lookInSysProp() != null) {
            CONSOLE_LOG.info("File name is defined in system property:'{}'", (Object)this.resolvedFileName);
            return this.resolvedFileName;
        }
        return this.lookInMainClassLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeOnTomcat(List<String> webappLocations) {
        try {
            if (this.lookInSysProp() != null) {
                String string = this.resolvedFileName;
                return string;
            }
            for (String path : webappLocations) {
                if (this.lookInWebappLocation(path, true) == null) continue;
                String string = this.getResolvedFileName();
                return string;
            }
            if (this.getResolvedFileName() == null) {
                CONSOLE_LOG.warn("Failed to find the file '{}' for tomcat", (Object)this.getDefaultFileName());
            }
            Iterator<String> iterator2 = null;
            return iterator2;
        }
        finally {
            DefaultTempFilesHandler.handleTemporaryFile(this, this.getResolvedFileName());
        }
    }

    public String executeWebApp(String webappLocation) {
        try {
            if (this.lookInSysProp() != null) {
                String string = this.resolvedFileName;
                return string;
            }
            this.lookInWebappLocation(webappLocation, false);
            if (this.resolvedFileName == null) {
                CONSOLE_LOG.warn("Failed to find the file '{}' under webappLocation='{}'", (Object)this.getDefaultFileName(), (Object)webappLocation);
            }
            String string = this.resolvedFileName;
            return string;
        }
        finally {
            DefaultTempFilesHandler.handleTemporaryFile(this, this.getResolvedFileName());
        }
    }

    protected String lookInWebappLocation(String webappLocation, boolean lookInWarOnly) {
        String[] otherArchTypes;
        if (this.lookInSubFolders(webappLocation) != null) {
            return this.getResolvedFileName();
        }
        this.lookInWebAppArchives(webappLocation, WAR);
        if (this.resolvedFileName != null || lookInWarOnly) {
            return this.resolvedFileName;
        }
        for (String type : otherArchTypes = new String[]{EAR, JAR}) {
            this.lookInWebAppArchives(webappLocation, type);
            if (this.resolvedFileName != null) break;
        }
        return this.resolvedFileName;
    }

    protected void lookInWebAppArchives(String webAppLocation, String archExtention) {
        List<File> archs = new FilesCollector().collectByExactMatchEnding(webAppLocation, archExtention, true);
        for (File archive : archs) {
            this.lookInsideJar(archive);
            if (this.resolvedFileName == null) continue;
            break;
        }
    }

    protected String lookInSysProp() {
        if (!StringUtils.isNullOrEmpty(System.getProperty(this.getSystemPropertyKey()))) {
            CONSOLE_LOG.info("Using file name from system property '{}'", (Object)this.getSystemPropertyKey());
            this.resolvedFileName = System.getProperty(this.getSystemPropertyKey());
        }
        return this.resolvedFileName;
    }

    protected String lookInMainClassLocation() {
        File mainClassLocation = this.jvmUtils.getApplicationJarFile();
        this.resolvedFileName = null;
        if (mainClassLocation == null) {
            CONSOLE_LOG.info("jar/main-lass location was not found, cannot resolve '{}'", (Object)this.getDefaultFileName());
            return null;
        }
        CONSOLE_LOG.info("looking by jar/main-class location:'{}' for '{}'", (Object)mainClassLocation, (Object)this.getDefaultFileName());
        if (this.lookInsideJar(mainClassLocation) != null) {
            return this.resolvedFileName;
        }
        if (this.lookInFolder(mainClassLocation.getParent()) != null) {
            return this.resolvedFileName;
        }
        if (this.lookInSubFolders(mainClassLocation.getAbsolutePath()) != null) {
            return this.resolvedFileName;
        }
        CONSOLE_LOG.info("The file '{}' was not found", (Object)this.getDefaultFileName());
        return null;
    }

    protected String lookInFolder(String folder) {
        List<File> txtFiles = new FilesCollector().collect(folder, false, new FilesCollector.FileNameFilter(){

            @Override
            public boolean matches(File other) {
                String fileName = other.getName();
                return fileName.equals(DefaultFileResolveProcedure.this.getDefaultFileName() + ".txt");
            }
        });
        return this.extractCollectedFile(txtFiles);
    }

    protected String lookInSubFolders(String root) {
        String fileNameWithExtension = this.getDefaultFileName() + ".txt";
        CONSOLE_LOG.info("Looking for '{}' in subfolders of '{}'", (Object)this.getDefaultFileName(), (Object)root);
        List<File> txtFiles = new FilesCollector().collectByExactMatchEnding(root, fileNameWithExtension, true);
        return this.extractCollectedFile(txtFiles);
    }

    private String extractCollectedFile(List<File> txtFiles) {
        Iterator<File> iterator2 = txtFiles.iterator();
        if (iterator2.hasNext()) {
            File f = iterator2.next();
            CONSOLE_LOG.info("Using the file '{}' found in '{}'", (Object)f.getName(), (Object)f.getParent());
            this.setResolvedFileName(f.getAbsolutePath());
            return this.getResolvedFileName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String lookInsideJar(File jarFileLocation) {
        if (jarFileLocation.isDirectory()) {
            return null;
        }
        jar = null;
        try {
            jar = new JarFile(jarFileLocation);
            entries = JarHelper.jarEntriesAsList(jar);
lbl7:
            // 4 sources

            for (JarEntry entry : entries) {
                if (entry.isDirectory()) continue;
                name = entry.getName();
                if (!FileNameUtils.matchRequestedName(name, this.getDefaultFileName(), ".txt")) ** GOTO lbl-1000
                this.resolvedFileName = JarHelper.createTempFile(jar, entry, this.normalizedRequestedFileName());
                this.setResolvedFileTemporary(true);
                DefaultFileResolveProcedure.CONSOLE_LOG.info("Using the file '{}' from '{}' ", (Object)name, (Object)jarFileLocation.getName());
                var7_8 = this.resolvedFileName;
                ** GOTO lbl24
            }
            ** GOTO lbl31
        }
        catch (Exception e) {
            try {
                DefaultFileResolveProcedure.CONSOLE_LOG.info("Failed to get entries from '{}'. Error: '{}'.", (Object)jarFileLocation.getPath(), (Object)e);
            }
            catch (Throwable var8_9) {
                JarHelper.closeJar(jar);
                throw var8_9;
            }
lbl24:
            // 1 sources

            JarHelper.closeJar(jar);
            return var7_8;
lbl-1000:
            // 1 sources

            {
                if (!this.isArchive(name)) ** GOTO lbl7
                DefaultFileResolveProcedure.CONSOLE_LOG.info("Looking for '{}' in embedded '{}'", (Object)this.getDefaultFileName(), (Object)name);
                embeddedJarTempFileName = JarHelper.createTempFile(jar, entry, name);
                this.resolvedFileName = this.lookInsideJar(new File(embeddedJarTempFileName));
                ** GOTO lbl7
            }
lbl31:
            // 1 sources

            JarHelper.closeJar(jar);
            return this.resolvedFileName;
            JarHelper.closeJar(jar);
            return this.resolvedFileName;
        }
    }

    protected boolean isArchive(String jarEntryName) {
        return jarEntryName.endsWith(WAR) || jarEntryName.endsWith(EAR);
    }

    private String normalizedRequestedFileName() {
        return this.addFileIndicator(this.defaultFileName);
    }

    private String addFileIndicator(String fileName) {
        if (!fileName.equals(this.defaultFileName) && !fileName.endsWith(".txt")) {
            return this.tempFileIndicator + fileName;
        }
        String filenameWithoutExtension = FileNameUtils.resolveFilenameWithoutExtension(fileName, ".txt");
        return filenameWithoutExtension + SUFFIX_SEPARATOR + this.tempFileIndicator + ".txt";
    }

    @Generated
    public String getResolvedFileName() {
        return this.resolvedFileName;
    }

    @Generated
    public boolean isResolvedFileTemporary() {
        return this.resolvedFileTemporary;
    }

    @Generated
    public String getSystemPropertyKey() {
        return this.systemPropertyKey;
    }

    @Generated
    public String getDefaultFileName() {
        return this.defaultFileName;
    }

    @Generated
    public JvmUtils getJvmUtils() {
        return this.jvmUtils;
    }

    @Generated
    public String getTempFileIndicator() {
        return this.tempFileIndicator;
    }

    @Generated
    public void setResolvedFileName(String resolvedFileName) {
        this.resolvedFileName = resolvedFileName;
    }

    @Generated
    public void setResolvedFileTemporary(boolean resolvedFileTemporary) {
        this.resolvedFileTemporary = resolvedFileTemporary;
    }

    @Generated
    public void setSystemPropertyKey(String systemPropertyKey) {
        this.systemPropertyKey = systemPropertyKey;
    }

    @Generated
    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }

    @Generated
    public void setJvmUtils(JvmUtils jvmUtils) {
        this.jvmUtils = jvmUtils;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFileResolveProcedure)) {
            return false;
        }
        DefaultFileResolveProcedure other = (DefaultFileResolveProcedure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resolvedFileName = this.getResolvedFileName();
        String other$resolvedFileName = other.getResolvedFileName();
        if (this$resolvedFileName == null ? other$resolvedFileName != null : !this$resolvedFileName.equals(other$resolvedFileName)) {
            return false;
        }
        if (this.isResolvedFileTemporary() != other.isResolvedFileTemporary()) {
            return false;
        }
        String this$systemPropertyKey = this.getSystemPropertyKey();
        String other$systemPropertyKey = other.getSystemPropertyKey();
        if (this$systemPropertyKey == null ? other$systemPropertyKey != null : !this$systemPropertyKey.equals(other$systemPropertyKey)) {
            return false;
        }
        String this$defaultFileName = this.getDefaultFileName();
        String other$defaultFileName = other.getDefaultFileName();
        if (this$defaultFileName == null ? other$defaultFileName != null : !this$defaultFileName.equals(other$defaultFileName)) {
            return false;
        }
        JvmUtils this$jvmUtils = this.getJvmUtils();
        JvmUtils other$jvmUtils = other.getJvmUtils();
        if (this$jvmUtils == null ? other$jvmUtils != null : !this$jvmUtils.equals(other$jvmUtils)) {
            return false;
        }
        String this$tempFileIndicator = this.getTempFileIndicator();
        String other$tempFileIndicator = other.getTempFileIndicator();
        return !(this$tempFileIndicator == null ? other$tempFileIndicator != null : !this$tempFileIndicator.equals(other$tempFileIndicator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultFileResolveProcedure;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resolvedFileName = this.getResolvedFileName();
        result = result * 59 + ($resolvedFileName == null ? 43 : $resolvedFileName.hashCode());
        result = result * 59 + (this.isResolvedFileTemporary() ? 79 : 97);
        String $systemPropertyKey = this.getSystemPropertyKey();
        result = result * 59 + ($systemPropertyKey == null ? 43 : $systemPropertyKey.hashCode());
        String $defaultFileName = this.getDefaultFileName();
        result = result * 59 + ($defaultFileName == null ? 43 : $defaultFileName.hashCode());
        JvmUtils $jvmUtils = this.getJvmUtils();
        result = result * 59 + ($jvmUtils == null ? 43 : $jvmUtils.hashCode());
        String $tempFileIndicator = this.getTempFileIndicator();
        result = result * 59 + ($tempFileIndicator == null ? 43 : $tempFileIndicator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultFileResolveProcedure(resolvedFileName=" + this.getResolvedFileName() + ", resolvedFileTemporary=" + this.isResolvedFileTemporary() + ", systemPropertyKey=" + this.getSystemPropertyKey() + ", defaultFileName=" + this.getDefaultFileName() + ", jvmUtils=" + this.getJvmUtils() + ", tempFileIndicator=" + this.getTempFileIndicator() + ")";
    }
}

