/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.datachunks;

import io.sealights.onpremise.agents.commons.datachunks.ChunkProcedure;
import io.sealights.onpremise.agents.commons.datachunks.ISizable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ChunksProcessor {
    private ChunkProcedure chunkProcedure;
    private int maxSize;

    public ChunksProcessor(int maxSize) {
        this.maxSize = maxSize;
    }

    public int processAsChunks(List<? extends ISizable> items) {
        List<ISizable> currentChunk;
        int totalItemsSent = 0;
        int totalChunks = 0;
        if (items == null || this.chunkProcedure == null) {
            return totalChunks;
        }
        int totalItemsToSend = items.size();
        do {
            if ((currentChunk = this.getChunk(items, totalItemsSent)) == null) {
                return totalChunks;
            }
            ++totalChunks;
            this.chunkProcedure.process(currentChunk);
        } while ((totalItemsSent += currentChunk.size()) < totalItemsToSend);
        return totalChunks;
    }

    private List<ISizable> getChunk(List<? extends ISizable> items, int totalItemsSent) {
        ISizable item;
        int chunkSize = 0;
        int index = totalItemsSent;
        if (items.size() <= totalItemsSent) {
            return null;
        }
        int indexOfLastItem = items.size() - 1;
        ArrayList<ISizable> currentChunk = new ArrayList<ISizable>();
        do {
            item = items.get(index++);
            currentChunk.add(item);
        } while ((chunkSize += item.getSize()) < this.maxSize && index <= indexOfLastItem);
        return currentChunk;
    }

    @Generated
    public ChunkProcedure getChunkProcedure() {
        return this.chunkProcedure;
    }

    @Generated
    public int getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public void setChunkProcedure(ChunkProcedure chunkProcedure) {
        this.chunkProcedure = chunkProcedure;
    }

    @Generated
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunksProcessor)) {
            return false;
        }
        ChunksProcessor other = (ChunksProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChunkProcedure this$chunkProcedure = this.getChunkProcedure();
        ChunkProcedure other$chunkProcedure = other.getChunkProcedure();
        if (this$chunkProcedure == null ? other$chunkProcedure != null : !this$chunkProcedure.equals(other$chunkProcedure)) {
            return false;
        }
        return this.getMaxSize() == other.getMaxSize();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChunksProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChunkProcedure $chunkProcedure = this.getChunkProcedure();
        result = result * 59 + ($chunkProcedure == null ? 43 : $chunkProcedure.hashCode());
        result = result * 59 + this.getMaxSize();
        return result;
    }

    @Generated
    public String toString() {
        return "ChunksProcessor(chunkProcedure=" + this.getChunkProcedure() + ", maxSize=" + this.getMaxSize() + ")";
    }
}

