/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.configuration.service.proxy;

import io.sealights.onpremise.agents.commons.configuration.SLRemoteConfiguration;
import io.sealights.onpremise.agents.commons.configuration.ServiceProxyCfgListener;
import io.sealights.onpremise.agents.commons.configuration.service.proxy.ConfigurationRequest;
import io.sealights.onpremise.agents.commons.configuration.service.proxy.ConfigurationResponse;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.environment.DefaultEnvironmentInfo;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;
import lombok.Generated;

public class ConfigurationServiceProxy<T extends SLAgentConfiguration>
extends ServiceProxyCfgListener<T> {
    public static final String VERSION = "v3";
    public static final String CONFIG = "config";

    public ConfigurationServiceProxy(T configuration) {
        super(configuration, false);
    }

    public ConfigurationResponse sendGetConfigurationRequest() {
        ConfigurationRequest request = this.createGetConfigurationRequest();
        String url = this.toUrl(request);
        try {
            SLHttpResult<ConfigurationResponse> configurationResponse = this.getHttpClient().sendGetRequest(new SLHttpRequest<ConfigurationResponse>(this.getTag(), url, ConfigurationResponse.class, true));
            return configurationResponse.getResponseObject();
        }
        catch (HttpExceptions.SLHttp404NotFoundException e) {
            return null;
        }
        catch (Exception e) {
            AgentLifeCycle.notifyException(ConfigurationServiceProxy.class, "Error on get configuration request", e);
            return null;
        }
    }

    private ConfigurationRequest createGetConfigurationRequest() {
        ConfigurationRequest request = new ConfigurationRequest();
        request.setAgentType(((SLRemoteConfiguration)this.getConfiguration()).getAgentType());
        request.setAgentVersion(DefaultEnvironmentInfo.getAgentVersion());
        request.setAgentId(AgentId.getAgentId());
        request.setAppName(((SLRemoteConfiguration)this.getConfiguration()).getAppName());
        request.setBranchName(((SLRemoteConfiguration)this.getConfiguration()).getBranchName());
        request.setBuildName(((SLRemoteConfiguration)this.getConfiguration()).getBuildName());
        request.setTestStage(((SLRemoteConfiguration)this.getConfiguration()).getTestStage());
        request.setLabId(((SLRemoteConfiguration)this.getConfiguration()).getLabId());
        return request;
    }

    private String toUrl(ConfigurationRequest request) {
        return new UrlBuilder().withHost(this.getServer()).withPath(VERSION, CONFIG).withQueryParam("agentType", request.getAgentType()).withQueryParam("agentVersion", request.getAgentVersion()).withQueryParam("agentId", request.getAgentId()).withQueryParam("appName", request.getAppName()).withQueryParam("branchName", request.getBranchName()).withQueryParam("buildName", request.getBuildName()).withQueryParam("testStage", request.getTestStage()).withQueryParam("labId", request.getLabId()).build();
    }

    @Override
    public String getTag() {
        return "CS";
    }

    @Override
    public void onConfigurationChanged(T configuration) {
    }

    public static final class URL {
        public static final String AGENT_TYPE = "agentType";
        public static final String AGENT_VERSION = "agentVersion";
        public static final String AGENT_ID = "agentId";
        public static final String APP = "appName";
        public static final String BRANCH = "branchName";
        public static final String BUILD = "buildName";
        public static final String TEST_STAGE = "testStage";
        public static final String LABID = "labId";

        @Generated
        private URL() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

