/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.configuration;

import io.sealights.onpremise.agents.commons.ReflectionUtils;
import io.sealights.onpremise.agents.commons.SlMapUtils;
import io.sealights.onpremise.agents.commons.configuration.ConfigurationListener;
import io.sealights.onpremise.agents.commons.configuration.SLRemoteConfiguration;
import io.sealights.onpremise.agents.commons.configuration.service.proxy.ConfigurationResponse;
import io.sealights.onpremise.agents.commons.configuration.service.proxy.ConfigurationServiceProxy;
import io.sealights.onpremise.agents.commons.functions.Procedure;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class RemoteConfigurationHandler<T extends SLAgentConfiguration>
extends Procedure {
    private static Logger LOG = LogFactory.getLogger(RemoteConfigurationHandler.class);
    private T configurationData;
    private ConfigurationResponse lastRemoteConfiguration;
    private ConfigurationServiceProxy<T> configurationServiceProxy;
    private List<ConfigurationListener<T>> listeners = new ArrayList<ConfigurationListener<T>>();

    public RemoteConfigurationHandler(T configurationData) {
        this.configurationData = configurationData;
    }

    @Override
    public void execute() {
        ConfigurationResponse remoteConfiguration = this.getRemoteConfiguration();
        if (remoteConfiguration != null && !remoteConfiguration.equals(this.lastRemoteConfiguration)) {
            this.lastRemoteConfiguration = remoteConfiguration;
            this.applyRemoteConfigurationChange();
        }
    }

    public void addListener(ConfigurationListener<T> configurationListener) {
        this.listeners.add(configurationListener);
    }

    protected ConfigurationResponse getRemoteConfiguration() {
        if (this.configurationServiceProxy == null) {
            this.configurationServiceProxy = new ConfigurationServiceProxy<T>(this.configurationData);
        }
        return this.configurationServiceProxy.sendGetConfigurationRequest();
    }

    private void applyRemoteConfigurationChange() {
        Map<String, Object> remoteConfig = this.lastRemoteConfiguration.getProperties();
        LinkedHashMap<String, Object> modifiedProps = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> failedModifyProps = new LinkedHashMap<String, Object>();
        boolean configEmpty = true;
        Map<String, Object> flatRemoteConfig = SlMapUtils.toFlatMap(remoteConfig);
        for (Map.Entry<String, Object> configurationItem : flatRemoteConfig.entrySet()) {
            Object value;
            String propertyName = configurationItem.getKey();
            if (ReflectionUtils.setValueSafeViaSetter(this.configurationData, propertyName, value = configurationItem.getValue(), false)) {
                modifiedProps.put(propertyName, value);
            } else {
                failedModifyProps.put(propertyName, value);
            }
            configEmpty = false;
        }
        if (!configEmpty) {
            this.notifyRemoteConfigurationChanged(modifiedProps, failedModifyProps);
        }
    }

    private void notifyRemoteConfigurationChanged(Map<String, Object> modifiedProps, Map<String, Object> failedModifyProps) {
        if (!modifiedProps.isEmpty()) {
            this.notifyListeners();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("updated properties: ").append(modifiedProps);
        if (!failedModifyProps.isEmpty()) {
            builder.append(", failed update properties:").append(failedModifyProps);
        }
        String msg = "Remote configuration was applied - " + builder.toString();
        LOG.info(msg);
        AgentLifeCycle.notifyInfoMsg(msg);
        AgentLifeCycle.notifyConfigurationChange(this.configurationData);
    }

    private void notifyListeners() {
        for (ConfigurationListener<SLAgentConfiguration> configurationListener : this.listeners) {
            SLAgentConfiguration cloned = (SLAgentConfiguration)((SLRemoteConfiguration)this.configurationData).cloneIt();
            configurationListener.onConfigurationChanged(cloned);
        }
    }

    @Generated
    public T getConfigurationData() {
        return this.configurationData;
    }

    @Generated
    public ConfigurationServiceProxy<T> getConfigurationServiceProxy() {
        return this.configurationServiceProxy;
    }

    @Generated
    public void setConfigurationServiceProxy(ConfigurationServiceProxy<T> configurationServiceProxy) {
        this.configurationServiceProxy = configurationServiceProxy;
    }

    @Generated
    public List<ConfigurationListener<T>> getListeners() {
        return this.listeners;
    }

    @Generated
    public void setListeners(List<ConfigurationListener<T>> listeners) {
        this.listeners = listeners;
    }
}

