/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.configuration;

import io.sealights.onpremise.agents.commons.ListUtils;
import io.sealights.onpremise.agents.commons.functions.SingleFunction;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenTruncated;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;

public final class ConfigurationPrinter {
    private static Logger LOG = LogFactory.getLogger(ConfigurationPrinter.class);
    private SLAgentConfiguration configurationData;

    public static void printConfiguration(SLAgentConfiguration configurationData, String configurationDecsriptor) {
        ConfigurationPrinter printer = new ConfigurationPrinter(configurationData);
        printer.print(configurationDecsriptor);
    }

    public ConfigurationPrinter(SLAgentConfiguration configurationData) {
        this.configurationData = configurationData;
    }

    public void print(String configurationDecsriptor) {
        LOG.info("*************************** {} Configuration **********************************", (Object)configurationDecsriptor);
        LOG.info("{}: ", (Object)this.configurationData.getClass().getName());
        LOG.info("--------------------------------------------------------------------------");
        List<Method> properties = this.getProperties(this.configurationData);
        for (Method property : properties) {
            this.printProperty(property, this.configurationData);
        }
        LOG.info("************************************************************************************");
    }

    private void printProperty(Method property, Object obj) {
        String GET_TOKEN = "getToken";
        try {
            String propertyName = property.getName();
            boolean isToken = "getToken".equals(propertyName);
            if (propertyName.startsWith("get")) {
                propertyName = this.firstCharToLowerCase(propertyName.replaceFirst("get", ""));
            }
            if (propertyName.startsWith("is")) {
                propertyName = this.firstCharToLowerCase(propertyName.replaceFirst("is", ""));
            }
            LOG.info("{}: '{}'", (Object)propertyName, isToken ? TokenTruncated.truncate((String)property.invoke(obj, new Object[0])) : property.invoke(obj, new Object[0]));
        }
        catch (Exception e) {
            String errMsg = String.format("{}:failed to read property:'%s'; error: %s", this.getClass().getName(), property, e);
            LOG.error(errMsg);
            AgentLifeCycle.notifyException(ConfigurationPrinter.class, errMsg, e);
        }
    }

    private String firstCharToLowerCase(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    private List<Method> getProperties(Object obj) {
        Method[] declaredMethods = obj.getClass().getDeclaredMethods();
        List<Method> properties = ListUtils.where(declaredMethods, new SingleFunction<Method, Boolean>(){

            @Override
            public Boolean execute(Method method) {
                return (method.getName().startsWith("get") || method.getName().startsWith("is")) && !method.getName().equals("getSystemProperty");
            }
        });
        return properties;
    }
}

