/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class SlCollections {
    @SafeVarargs
    private static <C extends Collection<T>, T> C fillCollection(C collection, T ... elements) {
        for (T element : elements) {
            collection.add(element);
        }
        return collection;
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... elements) {
        return SlCollections.fillCollection(new ArrayList(elements.length), elements);
    }

    @SafeVarargs
    public static <T> Set<T> newHashSet(T ... elements) {
        return SlCollections.fillCollection(new HashSet(elements.length), elements);
    }

    @SafeVarargs
    public static <T> Set<T> unmodifiableSet(T ... elements) {
        return Collections.unmodifiableSet(SlCollections.newHashSet(elements));
    }

    @SafeVarargs
    public static <KEY, VALUE> Map<KEY, VALUE> unmodifiableHashMap(Map.Entry<KEY, VALUE> ... entries) {
        HashMap<KEY, VALUE> hashMap = new HashMap<KEY, VALUE>();
        for (Map.Entry<KEY, VALUE> entry : entries) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Generated
    private SlCollections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

