/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import io.sealights.onpremise.agents.commons.SlCollections;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.logging.ExceptionStackTrace;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;

public class ReflectionUtils {
    private static final Logger LOG = LogFactory.getLogger(ReflectionUtils.class);
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final String WITH = "with";
    private static final Set<String> GETTER_PREFIXES = SlCollections.unmodifiableSet("get", "is");
    private static final Set<String> SETTER_PREFIXES = SlCollections.unmodifiableSet("set", "with");
    private static final ConcurrentMap<Class<?>, Map<String, PojoPropertyInfo>> globalClassPojoPropertiesInfoMap = new ConcurrentHashMap();

    public static List<Method> getGettersMethods(Object object) {
        Method[] methods;
        ArrayList<Method> getters = new ArrayList<Method>();
        for (Method method : methods = object.getClass().getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith(GET) && !methodName.startsWith(IS) || methodName.equals("getClass")) continue;
            getters.add(method);
        }
        return getters;
    }

    public static void printAllMethods(Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            String methodName = method.getName();
            System.out.println("##################### " + methodName + ":" + method.toString());
        }
    }

    public static Object invokeInstanceMethod(Object o, String methodName, Object ... params) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = null;
        Class<?> clazz = o.getClass();
        Object[] paramTypes = new Class[]{};
        if (params != null && params.length > 0) {
            paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = params[i].getClass();
            }
        }
        do {
            try {
                method = clazz.getMethod(methodName, (Class<?>[])paramTypes);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        } while (method == null && clazz != null);
        if (method == null) {
            throw new NoSuchMethodException("Couldn't find method '" + methodName + "' on class '" + o.getClass() + "' with params: " + Arrays.toString(paramTypes));
        }
        if (method.isVarArgs()) {
            int indexOfVarArgs = params.length - 1;
            params[indexOfVarArgs] = new Object[]{params[indexOfVarArgs]};
        }
        try {
            method.setAccessible(true);
            return method.invoke(o, params);
        }
        catch (Exception e) {
            System.err.println("Failed during reflection. e:" + ExceptionStackTrace.toString(e));
            return new Object();
        }
    }

    public static <R> R invokeInstanceMethodSafe(Object o, String methodName, R defaultVal, String errorMessage, Object ... params) {
        try {
            return (R)ReflectionUtils.invokeInstanceMethod(o, methodName, params);
        }
        catch (Exception e) {
            LOG.error(errorMessage, e);
            return defaultVal;
        }
    }

    public static <R> R getFieldSafe(Object o, String fieldName) {
        return ReflectionUtils.getFieldSafe(o, fieldName, true, false);
    }

    public static <R> R getFieldSafeSilent(Object o, String fieldName) {
        return ReflectionUtils.getFieldSafe(o, fieldName, true, true);
    }

    public static <R> R getFieldSafe(Object o, String fieldName, boolean forceGetPrivate, boolean silent) {
        Field field = null;
        try {
            Class<?> clazz = o.getClass();
            while (true) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    if (forceGetPrivate) {
                        field.setAccessible(true);
                    }
                    return (R)field.get(o);
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                    if (field == null && clazz != null) continue;
                    if (field == null) {
                        throw new NoSuchFieldException("Couldn't find field '" + fieldName + "' on class '" + o.getClass() + "'.");
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            String errMsg = "Can't get field: '{}'.";
            if (silent) {
                LOG.debug(errMsg, (Object)fieldName);
            }
            LOG.error(errMsg, (Object)fieldName, (Object)e);
        }
        return null;
    }

    public static void setFieldSafe(Object target, String fieldName, Object value, boolean forceSetPrivate, boolean silent) {
        Field field = null;
        try {
            if (target == null) {
                throw new NullPointerException("'target' cannot be null.");
            }
            Class<?> clazz = target.getClass();
            do {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    if (forceSetPrivate) {
                        field.setAccessible(true);
                    }
                    field.set(target, value);
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            } while (field == null && clazz != null);
            if (field == null) {
                throw new NoSuchFieldException("Couldn't find field '" + fieldName + "' on class '" + target.getClass() + "'.");
            }
        }
        catch (Exception e) {
            String errMsg = "Can't get field: '{}'.";
            if (silent) {
                LOG.warn(errMsg, (Object)fieldName);
            }
            LOG.error(errMsg, (Object)fieldName, (Object)e);
        }
    }

    @Deprecated
    public static boolean setValueSafe(Object target, String setterName, Object value) {
        if (target == null || StringUtils.isNullOrEmpty(setterName) || value == null) {
            return false;
        }
        String fullSetterName = setterName;
        Object originalTarget = target;
        Class<?> typeOfValue = value.getClass();
        try {
            Class<?> typeObjectOfTarget = target.getClass();
            String[] properties = setterName.split("\\.");
            if (properties.length > 0) {
                int indexOfSetter = properties.length - 1;
                setterName = properties[properties.length - 1];
                for (int i = 0; i < indexOfSetter; ++i) {
                    String propertyName = properties[i];
                    String getter = ReflectionUtils.toGetterName(propertyName);
                    target = typeObjectOfTarget.getMethod(getter, new Class[0]).invoke(target, new Object[0]);
                    typeObjectOfTarget = target.getClass();
                }
            }
            setterName = ReflectionUtils.toSetterName(setterName);
            Method setterMethod = typeObjectOfTarget.getMethod(setterName, typeOfValue);
            setterMethod.invoke(target, value);
        }
        catch (Exception e) {
            String message = "Failed to set value. setterName:'" + fullSetterName + "', Target: '" + originalTarget + "', typeOfValue: '" + typeOfValue + "'', value: '" + value + "'";
            AgentLifeCycle.notifyException(ReflectionUtils.class, message, e);
            return false;
        }
        return true;
    }

    private static String toSetterName(String setterName) {
        return SET + StringUtils.capitalizeFirstCharacter(setterName);
    }

    private static String toGetterName(String propertyName) {
        return GET + StringUtils.capitalizeFirstCharacter(propertyName);
    }

    private static boolean isSetter(Method method) {
        return method.getParameterCount() == 1 && ReflectionUtils.isSetterName(method.getName());
    }

    private static boolean isGetter(Method method) {
        return method.getParameterCount() == 0 && ReflectionUtils.isGetterName(method.getName());
    }

    private static boolean isSetterName(String methodName) {
        return methodName.startsWith(SET);
    }

    private static boolean isGetterName(String methodName) {
        return methodName.startsWith(GET) || methodName.startsWith(IS);
    }

    private static Map<String, PojoPropertyInfo> lookupPojoProperties(Object object) {
        if (object == null) {
            return Collections.emptyMap();
        }
        return ReflectionUtils.lookupPojoProperties(object.getClass());
    }

    private static String toPropertyNameByPrefix(String methodName, String prefix) {
        if (methodName.startsWith(prefix)) {
            char c = methodName.charAt(prefix.length());
            return Character.toLowerCase(c) + methodName.substring(prefix.length() + 1);
        }
        return null;
    }

    private static String toPropertyNameByPrefixes(String methodName, Collection<String> prefixes) {
        return prefixes.stream().map(prefix -> ReflectionUtils.toPropertyNameByPrefix(methodName, prefix)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String toPropertyNameFromGetterName(String methodName) {
        return ReflectionUtils.toPropertyNameByPrefixes(methodName, GETTER_PREFIXES);
    }

    private static String toPropertyNameFromSetterName(String methodName) {
        return ReflectionUtils.toPropertyNameByPrefixes(methodName, SETTER_PREFIXES);
    }

    private static Map<String, PojoPropertyInfo> lookupPojoProperties(Class<?> cl) {
        if (globalClassPojoPropertiesInfoMap.containsKey(cl)) {
            return (Map)globalClassPojoPropertiesInfoMap.get(cl);
        }
        Method[] methods = cl.getMethods();
        HashMap<String, PojoPropertyInfo> map2 = new HashMap<String, PojoPropertyInfo>();
        for (Method method : methods) {
            PojoPropertyInfo pojoPropertyInfo;
            String propertyName;
            String methodName = method.getName();
            if (ReflectionUtils.isGetter(method)) {
                propertyName = ReflectionUtils.toPropertyNameFromGetterName(methodName);
                pojoPropertyInfo = map2.computeIfAbsent(propertyName, PojoPropertyInfo::new);
                pojoPropertyInfo.setGetter(method);
            }
            if (!ReflectionUtils.isSetter(method)) continue;
            propertyName = ReflectionUtils.toPropertyNameFromSetterName(methodName);
            pojoPropertyInfo = map2.computeIfAbsent(propertyName, PojoPropertyInfo::new);
            pojoPropertyInfo.setSetter(method);
        }
        globalClassPojoPropertiesInfoMap.put(cl, map2);
        return map2;
    }

    public static boolean setValueSafeViaSetter(Object target, String inputPropertyName, Object value, boolean notifyCockpitOnException) {
        String nestedPropertyName;
        String rootPropertyName;
        if (value == null) {
            return false;
        }
        if (inputPropertyName.contains(".")) {
            int firstDotIndex = inputPropertyName.indexOf(".");
            rootPropertyName = inputPropertyName.substring(0, firstDotIndex);
            nestedPropertyName = inputPropertyName.substring(firstDotIndex + 1);
        } else {
            rootPropertyName = inputPropertyName;
            nestedPropertyName = null;
        }
        Map<String, PojoPropertyInfo> propertyGettersSettersMap = ReflectionUtils.lookupPojoProperties(target);
        PojoPropertyInfo rootPojoPropertyInfo = propertyGettersSettersMap.get(rootPropertyName);
        if (rootPojoPropertyInfo == null) {
            return false;
        }
        try {
            if (nestedPropertyName == null) {
                Method setter = rootPojoPropertyInfo.getSetter();
                setter.invoke(target, value);
                return true;
            }
            Method getter = rootPojoPropertyInfo.getGetter();
            Object nestedObject = getter.invoke(target, new Object[0]);
            return ReflectionUtils.setValueSafeViaSetter(nestedObject, nestedPropertyName, value, notifyCockpitOnException);
        }
        catch (Exception e) {
            String message = "Failed to set value. inputPropertyName:'" + inputPropertyName + "', Target: '" + target + "', typeOfValue: '" + value.getClass() + "', value: '" + value + "'";
            if (notifyCockpitOnException) {
                AgentLifeCycle.notifyException(ReflectionUtils.class, message, e);
            }
            LOG.error(message);
            return false;
        }
    }

    public static boolean setValueSafeViaSetter(Object target, String inputPropertyName, Object value) {
        return ReflectionUtils.setValueSafeViaSetter(target, inputPropertyName, value, false);
    }

    public static class PojoPropertyInfo {
        private final String name;
        private Method getter;
        private Method setter;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Method getGetter() {
            return this.getter;
        }

        @Generated
        public Method getSetter() {
            return this.setter;
        }

        @Generated
        public void setGetter(Method getter) {
            this.getter = getter;
        }

        @Generated
        public void setSetter(Method setter) {
            this.setter = setter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PojoPropertyInfo)) {
                return false;
            }
            PojoPropertyInfo other = (PojoPropertyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Method this$getter = this.getGetter();
            Method other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !((Object)this$getter).equals(other$getter)) {
                return false;
            }
            Method this$setter = this.getSetter();
            Method other$setter = other.getSetter();
            return !(this$setter == null ? other$setter != null : !((Object)this$setter).equals(other$setter));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PojoPropertyInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Method $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : ((Object)$getter).hashCode());
            Method $setter = this.getSetter();
            result = result * 59 + ($setter == null ? 43 : ((Object)$setter).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ReflectionUtils.PojoPropertyInfo(name=" + this.getName() + ", getter=" + this.getGetter() + ", setter=" + this.getSetter() + ")";
        }

        @ConstructorProperties(value={"name"})
        @Generated
        public PojoPropertyInfo(String name) {
            this.name = name;
        }
    }
}

