/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import io.sealights.onpremise.agents.commons.functions.FunctionsChain;
import io.sealights.onpremise.agents.commons.functions.SingleProcedure;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;

public class OutgoingMessageQueue<T> {
    private volatile boolean isEnabled;
    private ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private SingleProcedure<Boolean> onEnabledChanged;
    private SingleProcedure<Integer> onQueueFull;
    private int maxItemsInQueue;
    private static final int MAX_ITEMS_IN_QUEUE = 1000;
    private static Logger LOG = LogFactory.getLogger(OutgoingMessageQueue.class);
    private String name;

    public OutgoingMessageQueue(String name) {
        this(1000, name);
    }

    public OutgoingMessageQueue(int maxItemsInQueue, String name) {
        this.maxItemsInQueue = maxItemsInQueue;
        this.name = name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void addOnEnabledChanged(SingleProcedure<Boolean> handler) {
        this.onEnabledChanged = FunctionsChain.combine(this.onEnabledChanged, handler);
    }

    public void addOnQueueFull(SingleProcedure<Integer> handler) {
        this.onQueueFull = FunctionsChain.combine(this.onQueueFull, handler);
    }

    public void setEnabled(boolean isEnabled) {
        if (this.isEnabled != isEnabled) {
            this.isEnabled = isEnabled;
            if (this.onEnabledChanged != null) {
                this.onEnabledChanged.execute(isEnabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueMessage(T message) {
        if (!this.isEnabled || message == null) {
            return false;
        }
        boolean messageAdded = false;
        ConcurrentLinkedQueue<T> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            messageAdded = this.queue.add(message);
            this.checkQueueSize();
        }
        return messageAdded;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requeueMessages(List<T> messages) {
        int queueSizeBefore;
        if (!this.isEnabled || messages == null || messages.size() == 0 || this.isQueueFull()) {
            if (messages == null) {
                this.logInfoMessage("nothing to requeue: messages are 'null'", new Object[0]);
            } else {
                this.logInfoMessage("cannot requeue messages, {} messages will be dropped", messages.size());
            }
            return false;
        }
        int queueSizeAfter = queueSizeBefore = this.getQueueSize();
        ConcurrentLinkedQueue<T> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            for (T message : messages) {
                this.queue.add(message);
            }
            queueSizeAfter = this.getQueueSize();
            this.checkQueueSize();
        }
        this.logInfoMessage("{} messages were requeued; queue size before:{}, queue size after:{}", messages.size(), queueSizeBefore, queueSizeAfter);
        return true;
    }

    public boolean isQueueFull() {
        boolean fullQueue;
        int queueLimit = this.maxItemsInQueue < 0 ? 1000 : this.maxItemsInQueue;
        boolean bl = fullQueue = this.getQueueSize() >= queueLimit;
        if (fullQueue) {
            this.logInfoMessage("queue is full: queue size exceeds queueLimit:{}", queueLimit);
        }
        return fullQueue;
    }

    public int getMaxItemsInQueue() {
        return this.maxItemsInQueue;
    }

    public void setMaxItemsInQueue(int maxItemsInQueue) {
        this.maxItemsInQueue = maxItemsInQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getQueueContentsAndEmptyQueue() {
        List<T> returnedItems;
        ConcurrentLinkedQueue<T> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            returnedItems = this.cloneQueue();
            this.queue.clear();
        }
        this.logInfoMessage("queue was cleaned, {} items were extracted", returnedItems.size());
        return returnedItems;
    }

    private List<T> cloneQueue() {
        T item;
        ArrayList<T> returnedItems = new ArrayList<T>();
        do {
            if ((item = this.queue.poll()) == null) continue;
            returnedItems.add(item);
        } while (item != null);
        return returnedItems;
    }

    protected void logInfoMessage(String format, Object ... arguments) {
        LOG.info("'" + this.name + "' - " + format, arguments);
    }

    private void checkQueueSize() {
        if (this.isQueueFull() && this.onQueueFull != null) {
            this.onQueueFull.execute(this.queue.size());
        }
    }
}

