/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import io.sealights.onpremise.agents.commons.functions.SingleFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ListUtils {
    public static <T> List<T> where(Collection<T> items, SingleFunction<T, Boolean> predicate) {
        if (items == null) {
            return null;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T item : items) {
            if (!predicate.execute(item).booleanValue()) continue;
            results.add(item);
        }
        return results;
    }

    public static <T> List<T> where(T[] items, SingleFunction<T, Boolean> predicate) {
        List<T> list = Arrays.asList(items);
        List<T> result = ListUtils.where(list, predicate);
        return result;
    }

    public static <T> T firstOrDefault(Collection<T> list, SingleFunction<T, Boolean> predicate) {
        if (list == null) {
            return null;
        }
        for (T item : list) {
            if (!predicate.execute(item).booleanValue()) continue;
            return item;
        }
        return null;
    }
}

