/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import java.util.Map;
import java.util.Objects;

public class ImmutableMapEntry<KEY, VALUE>
implements Map.Entry<KEY, VALUE> {
    private final KEY key;
    private final VALUE value;

    private ImmutableMapEntry(KEY key, VALUE value) {
        this.key = key;
        this.value = value;
    }

    public static <KEY, VALUE> ImmutableMapEntry<KEY, VALUE> entryOf(KEY key, VALUE value) {
        if (key == null) {
            throw new IllegalArgumentException("KEY can not be null");
        }
        return new ImmutableMapEntry<KEY, VALUE>(key, value);
    }

    @Override
    public KEY getKey() {
        return this.key;
    }

    @Override
    public VALUE getValue() {
        return this.value;
    }

    @Override
    public VALUE setValue(VALUE value) {
        throw new UnsupportedOperationException("Can not set value for immutable object");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMapEntry that = (ImmutableMapEntry)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

