/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import io.sealights.onpremise.agents.infra.logging.ExceptionStackTrace;

public class ErrorsManager {
    private String lastErrorAsString;

    public static ErrorsManager getInstance() {
        return SingletonHolder.getInstance();
    }

    public void clear() {
        this.lastErrorAsString = null;
    }

    public String getLastErrorAsString() {
        return this.lastErrorAsString;
    }

    public void setLastErrorAsString(Exception lastError) {
        if (lastError != null) {
            this.lastErrorAsString = ExceptionStackTrace.toString(lastError);
        }
    }

    public void setLastErrorAsString(Throwable lastError) {
        if (lastError != null) {
            this.lastErrorAsString = ExceptionStackTrace.toString(lastError);
        }
    }

    private static class SingletonHolder {
        static final ErrorsManager INSTANCE = new ErrorsManager();

        private SingletonHolder() {
        }

        static ErrorsManager getInstance() {
            return INSTANCE;
        }
    }
}

