/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import io.sealights.onpremise.agents.infra.jarutils.JarReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.jar.JarFile;

public class EmbeddedJarUtils {
    private static JarReader jarReader = new JarReader();

    public static JarFile loadEmbeddedJar(String jarNameWithoutExtension, String filesStorage) throws Exception {
        InputStream jarStream = EmbeddedJarUtils.getEmbeddedJarInputStream(jarNameWithoutExtension);
        return jarReader.copyJarStreamToTmpJarFile(jarStream, jarNameWithoutExtension, filesStorage);
    }

    public static File loadEmbeddedJarFile(String jarNameWithoutExtension, String filesStorage) throws Exception {
        InputStream jarStream = EmbeddedJarUtils.getEmbeddedJarInputStream(jarNameWithoutExtension);
        return jarReader.copyJarStreamToTmpFile(jarStream, jarNameWithoutExtension, filesStorage);
    }

    private static InputStream getEmbeddedJarInputStream(String jarNameWithoutExtension) throws FileNotFoundException {
        String jarNameWithExtension = jarNameWithoutExtension + ".jar";
        InputStream jarStream = EmbeddedJarUtils.class.getResourceAsStream("/" + jarNameWithExtension);
        if (jarStream == null) {
            throw new FileNotFoundException(jarNameWithExtension);
        }
        return jarStream;
    }
}

