/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationsExcludedFilter {
    private Set<String> excludedAnnotations;

    public AnnotationsExcludedFilter(String annotationsExcludedParameter) {
        if (StringUtils.isNotEmpty(annotationsExcludedParameter)) {
            this.excludedAnnotations = Arrays.stream(annotationsExcludedParameter.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).map(String::toLowerCase).collect(Collectors.toSet());
        }
    }

    public boolean matchAny(Collection<AnnotationInfo> annotations) {
        if (this.excludedAnnotations != null) {
            return annotations.stream().map(AnnotationInfo::getName).map(String::toLowerCase).anyMatch(this.excludedAnnotations::contains);
        }
        return false;
    }
}

