/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.scm.utils;

import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import java.util.Collection;
import java.util.Map;

public final class ToStringFormatter {
    public static String toStringCompact(Map<String, ClassSignature> map2) {
        StringBuffer buf = new StringBuffer();
        int ctr = 0;
        for (String key : map2.keySet()) {
            buf.append(String.format("\t[%d]\t%s -> %s", ctr++, key, map2.get(key).toStringCompact()));
            if (ctr >= map2.size()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    private ToStringFormatter() {
    }

    public static class MetaDataFormatter {
        public static String toStringMetaDataCompact(Map<String, Object> metaData) {
            StringBuilder buf = new StringBuilder();
            int ctr = 0;
            int last = metaData.size();
            for (String key : metaData.keySet()) {
                buf.append(String.format("\t%-20s: %s", key, MetaDataFormatter.toStringMetaDataEntry(key, metaData.get(key))));
                if (ctr++ >= last) continue;
                buf.append("\n");
            }
            return buf.toString();
        }

        private static String toStringMetaDataEntry(String key, Object entry) {
            String NOT_PRINTABLE = "... not printed here ...";
            if (entry == null) {
                return "null";
            }
            StringBuilder buf = new StringBuilder();
            if (entry instanceof Collection) {
                Collection castEntry = (Collection)entry;
                if (castEntry.isEmpty()) {
                    buf.append("empty collection");
                } else {
                    buf.append("collection of ").append(castEntry.size()).append(" entries - ");
                    if (MetaDataFormatter.isPrintableCollection(key)) {
                        buf.append(entry);
                    } else {
                        buf.append("... not printed here ...");
                    }
                }
            } else if (entry instanceof ScanModeArguments) {
                buf.append("... not printed here ...");
            } else {
                buf.append(entry);
            }
            return buf.toString();
        }

        private static boolean isPrintableCollection(String key) {
            String[] notPrintableCollectionsKeys;
            for (String current : notPrintableCollectionsKeys = new String[0]) {
                if (!current.equals(key)) continue;
                return false;
            }
            return true;
        }
    }
}

