/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.inputvalidator;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionValidator;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.NamingStyle;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.PullRequestBuildSessionInput;
import io.sealights.onpremise.agents.infra.configuration.validation.PackagesIncludedValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class PullRequestBuildSessionInputValidator
extends BuildSessionValidator<PullRequestBuildSessionInput> {
    public PullRequestBuildSessionInputValidator(PackagesIncludedValidator packagesIncludedValidator) {
        super(packagesIncludedValidator);
    }

    @Override
    public ValidationResult validate(ModesOptions.ExecMode execMode, PullRequestBuildSessionInput bsInput) {
        NamingStyle style = NamingStyle.getStyle(execMode);
        if (StringUtils.isNullOrEmpty(bsInput.getBuildSessionId())) {
            if (StringUtils.isNullOrEmpty(bsInput.getAppName())) {
                this.validationResult.addError(this.buildMissedArgumentError(style.getAppPropertyName()));
            }
            if (StringUtils.isNullOrEmpty(bsInput.getRepositoryUrl())) {
                this.validationResult.addError(this.buildMissedArgumentError("repositoryUrl"));
            }
            if (bsInput.getPullRequestNumber() == null) {
                this.validationResult.addError(this.buildMissedArgumentError("pullRequestNumber"));
            }
            if (StringUtils.isNullOrEmpty(bsInput.getLatestCommit())) {
                this.validationResult.addError(this.buildMissedArgumentError("latestCommit"));
            }
            if (StringUtils.isNullOrEmpty(bsInput.getTargetBranch())) {
                this.validationResult.addError(this.buildMissedArgumentError("targetBranch"));
            }
            ValidationResult packagesValidationResult = this.packagesIncludedValidator.validate(bsInput.getPackagesIncluded());
            this.validationResult.add(packagesValidationResult);
        }
        return this.validationResult;
    }
}

