/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.inputvalidator;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import lombok.Generated;

public enum NamingStyle {
    CONFIG_NAMING(ModesOptions.ExecMode.CONFIG, "appname", "buildname", "branchname"),
    POM_NAMING(ModesOptions.ExecMode.POM, "appName", "buildName", "branchName"),
    GRADLE_NAMING(ModesOptions.ExecMode.GRADLE_INTEGRATE, "appName", "buildName", "branchName"),
    SCAN_NAMING(ModesOptions.ExecMode.SCAN, "appname", "build", "branch");

    private ModesOptions.ExecMode execMode;
    private String appPropertyName;
    private String buildPropertyName;
    private String branchPropertyName;

    public static NamingStyle getStyle(ModesOptions.ExecMode execMode) {
        NamingStyle style = null;
        switch (execMode) {
            case POM: 
            case GRADLE_INTEGRATE: 
            case CONFIG: 
            case SCAN: {
                break;
            }
            default: {
                execMode = ModesOptions.ExecMode.CONFIG;
            }
        }
        for (NamingStyle v : NamingStyle.values()) {
            if (execMode != v.execMode) continue;
            style = v;
            break;
        }
        return style;
    }

    private NamingStyle(ModesOptions.ExecMode execMode, String appPropertyName, String buildPropertyName, String branchPropertyName) {
        this.execMode = execMode;
        this.appPropertyName = appPropertyName;
        this.buildPropertyName = buildPropertyName;
        this.branchPropertyName = branchPropertyName;
    }

    @Generated
    public String getAppPropertyName() {
        return this.appPropertyName;
    }

    @Generated
    public String getBuildPropertyName() {
        return this.buildPropertyName;
    }

    @Generated
    public String getBranchPropertyName() {
        return this.branchPropertyName;
    }
}

