/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.inputvalidator;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionInput;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionValidator;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.NamingStyle;
import io.sealights.onpremise.agents.infra.configuration.validation.PackagesIncludedValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;

public class BuildSessionInputValidator
extends BuildSessionValidator<BuildSessionInput> {
    public BuildSessionInputValidator() {
    }

    public BuildSessionInputValidator(PackagesIncludedValidator packagesIncludedValidator) {
        super(packagesIncludedValidator);
    }

    @Override
    public ValidationResult validate(ModesOptions.ExecMode execMode, BuildSessionInput bsInput) {
        NamingStyle style = NamingStyle.getStyle(execMode);
        if (StringUtils.isNullOrEmpty(bsInput.getBuildSessionId())) {
            if (StringUtils.isNullOrEmpty(bsInput.getAppName())) {
                this.validationResult.addError(this.buildMissedArgumentError(style.getAppPropertyName()));
            }
            if (StringUtils.isNullOrEmpty(bsInput.getBuild())) {
                this.validationResult.addError(this.buildMissedArgumentError(style.getBuildPropertyName()));
            }
            if (StringUtils.isNullOrEmpty(bsInput.getBranch())) {
                this.validationResult.addError(this.buildMissedArgumentError(style.getBranchPropertyName()));
            }
            ValidationResult packagesValidationResult = this.packagesIncludedValidator.validate(bsInput.getPackagesIncluded());
            this.validationResult.add(packagesValidationResult);
        }
        return this.validationResult;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildSessionInputValidator)) {
            return false;
        }
        BuildSessionInputValidator other = (BuildSessionInputValidator)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildSessionInputValidator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = 1;
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BuildSessionInputValidator()";
    }
}

