/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.inputvalidator;

import io.sealights.onpremise.agents.buildscanner.main.cli.build.BaseBuildModeArguments;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;

public class BuildModeArgumentsValidator {
    private static Logger LOG = LogFactory.getLogger(BuildModeArgumentsValidator.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String MISSED_BUILD_SESSION_ID = "invalid input: build session id is not provided; cannot proceed";
    private static final String MISSED_TOKEN = "invalid input: token is not provided; cannot proceed";
    private BaseBuildModeArguments arguments;

    public boolean validate() {
        this.arguments.setToken(ArgumentFileReader.resolve(this.arguments.getToken(), this.arguments.getTokenFile()));
        this.arguments.setBuildSessionId(ArgumentFileReader.resolve(this.arguments.getBuildSessionId(), this.arguments.getBuildSessionIdFile()));
        if (StringUtils.isNullOrEmpty(this.arguments.getToken())) {
            CONSOLE_LOG.info(MISSED_TOKEN);
            LOG.error(MISSED_TOKEN);
            return false;
        }
        if (StringUtils.isNullOrEmpty(this.arguments.getBuildSessionId())) {
            CONSOLE_LOG.info(MISSED_BUILD_SESSION_ID);
            LOG.error(MISSED_BUILD_SESSION_ID);
            return false;
        }
        return true;
    }

    @ConstructorProperties(value={"arguments"})
    @Generated
    public BuildModeArgumentsValidator(BaseBuildModeArguments arguments) {
        this.arguments = arguments;
    }
}

