/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.plugins;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PomIntegrationOptions {
    private Option pom;
    private Option workspacePath;
    private Option configFile;
    private Option recursive;
    private Option pluginVersion;
    private Option modifyParentPom;
    private Option mavenLocalRepoPath;
    private Option enableNoneZeroErrorCode;

    public PomIntegrationOptions() {
        this.initPom();
        this.initWorkspacePath();
        this.initConfigFile();
        this.initRecursive();
        this.initPluginVersion();
        this.initParentPomOptions();
        this.initEnableNoneZeroErrorCode();
    }

    public Options getOptions() {
        Options options = new Options();
        options.addOption(this.pom);
        options.addOption(this.workspacePath);
        options.addOption(this.configFile);
        options.addOption(this.recursive);
        options.addOption(this.pluginVersion);
        options.addOption(this.modifyParentPom);
        options.addOption(this.mavenLocalRepoPath);
        options.addOption(this.enableNoneZeroErrorCode);
        return options;
    }

    private void initPom() {
        this.pom = ModesOptions.ExecMode.POM.createOption();
    }

    public void initWorkspacePath() {
        this.workspacePath = Option.builder("workspacepath").desc("Path to the workspace where the pom files exists").hasArg().required().build();
    }

    public void initRecursive() {
        this.recursive = Option.builder("r").longOpt("recursive").desc("Path to the workspace where the pom files exists").hasArg().build();
    }

    private void initEnableNoneZeroErrorCode() {
        this.enableNoneZeroErrorCode = Option.builder("enableNoneZeroErrorCode").desc("Indicates that the Build Scanner should return with error code in case of scan failure. On: return 1, Off: return 0").build();
    }

    private void initConfigFile() {
        this.configFile = Option.builder("configfile").desc("The path to json file that contains parameters for pom file").hasArg().required().build();
    }

    private void initPluginVersion() {
        this.pluginVersion = Option.builder("pluginversion").desc("Version of the sealights-maven-plugin to be used").hasArg().build();
    }

    private void initParentPomOptions() {
        this.modifyParentPom = Option.builder("modifyParentPom").desc("Flag to enable parent pom modification in -pom mode").build();
        this.mavenLocalRepoPath = Option.builder("mavenLocalRepoPath").desc("Path to the maven local repository, usually ${user.home}/.m2/repository").hasArg().build();
    }
}

