/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.plugins;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GradleIntegrationOptions {
    private Option gradleScript;
    private Option workspacePath;
    private Option configFile;
    private Option excludedProjects;
    private Option includedProjects;
    private Option pluginVersion;
    private Option repoConfig;
    private Option useOnlyProjectRepoSection;
    private Option enableNoneZeroErrorCode;

    public GradleIntegrationOptions() {
        this.initGradleScript();
        this.initWorkspacePath();
        this.initConfigFile();
        this.initExcludedProjects();
        this.initIncludedProjects();
        this.initRepoConfig();
        this.initEnableNoneZeroErrorCode();
        this.initPluginVersion();
        this.initUseOnlyProjectRepoSection();
    }

    public Options getOptions() {
        Options options = new Options();
        options.addOption(this.gradleScript);
        options.addOption(this.workspacePath);
        options.addOption(this.configFile);
        options.addOption(this.pluginVersion);
        options.addOption(this.excludedProjects);
        options.addOption(this.includedProjects);
        options.addOption(this.repoConfig);
        options.addOption(this.enableNoneZeroErrorCode);
        options.addOption(this.useOnlyProjectRepoSection);
        return options;
    }

    private void initGradleScript() {
        this.gradleScript = ModesOptions.ExecMode.GRADLE_INTEGRATE.createOption();
    }

    public void initWorkspacePath() {
        this.workspacePath = Option.builder("workspacepath").desc("Path to the workspace where the root projects build.gradle file exists").hasArg().required().build();
    }

    private void initEnableNoneZeroErrorCode() {
        this.enableNoneZeroErrorCode = Option.builder("enableNoneZeroErrorCode").desc("Indicates that the Build Scanner should return with error code in case of scan failure. On: return 1, Off: return 0").build();
    }

    private void initConfigFile() {
        this.configFile = Option.builder("configfile").desc("The path to json file that contains parameters for SeaLights").hasArg().required().build();
    }

    private void initExcludedProjects() {
        this.excludedProjects = Option.builder("excludedProjects").desc("Comma-separated list of Gradle (sub)projects to exclude from SeaLights integration. Overrides 'includedProjects'").hasArg().build();
    }

    private void initIncludedProjects() {
        this.includedProjects = Option.builder("includedProjects").desc("Comma-separated list of Gradle (sub)projects to include in SeaLights integration. When empty, all projects are included").hasArg().build();
    }

    private void initRepoConfig() {
        this.repoConfig = Option.builder("repoConfig").desc("The Gradle configuration of repositories used for Gradle integration. The passed code is not validated").hasArg().build();
    }

    private void initPluginVersion() {
        this.pluginVersion = Option.builder("pluginversion").desc("Version of the sealights-gradle-plugin to be used").hasArg().build();
    }

    private void initUseOnlyProjectRepoSection() {
        this.useOnlyProjectRepoSection = Option.builder("useOnlyProjectRepoSection").desc("Flag to skip generating repositories section and use only pre-defined repos for build.gradle file").build();
    }
}

