/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.config;

import io.sealights.onpremise.agents.buildscanner.main.cli.CliConstants;
import io.sealights.onpremise.agents.buildscanner.main.cli.config.BaseConfigModeOptions;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PrConfigModeOptions
extends BaseConfigModeOptions {
    private Option repositoryUrl;
    private Option pullRequestNumber;
    private Option latestCommit;
    private Option targetBranch;
    private Option buildsessionidfile;

    public PrConfigModeOptions() {
        super(CliConstants.MODES.PRCONFIG, "Flag to indicate pull-request configuration mode", false);
        this.initOptions();
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        options.addOption(this.repositoryUrl);
        options.addOption(this.pullRequestNumber);
        options.addOption(this.latestCommit);
        options.addOption(this.targetBranch);
        options.addOption(this.buildsessionidfile);
        return options;
    }

    @Override
    protected void initOtherOptions() {
        this.repositoryUrl = Option.builder("repoUrl").desc("The repository url, where pull request was created").required().hasArg().build();
        this.pullRequestNumber = Option.builder("pullRequestNumber").desc("The pull request number").required().hasArg().build();
        this.latestCommit = Option.builder("latestCommit").desc("The latest commit SHA").required().hasArg().build();
        this.targetBranch = Option.builder("targetBranch").desc("A branch the pull request is compared with").required().hasArg().build();
        this.buildsessionidfile = Option.builder("buildsessionidfile").desc("Path to a file to save the build session id in (default: <user.dir>/buildSessionId.txt).").hasArg().build();
    }
}

