/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.config;

import io.sealights.onpremise.agents.buildscanner.main.cli.CliConstants;
import io.sealights.onpremise.agents.buildscanner.main.cli.config.BaseConfigModeOptions;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ConfigModeOptions
extends BaseConfigModeOptions {
    private Option buildname;
    private Option branchname;
    private Option buildsessionid;
    private Option buildsessionidfile;
    private Option includedFilePatterns;
    private Option excludedFilePatterns;
    private Option includedNamespaces;
    private Option excludedNamespaces;

    public ConfigModeOptions() {
        super(CliConstants.MODES.CONFIG, "Flag to indicate configuration mode", true);
        this.initOptions();
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        options.addOption(this.buildname);
        options.addOption(this.branchname);
        options.addOption(this.buildsessionid);
        options.addOption(this.buildsessionidfile);
        options.addOption(this.includedNamespaces);
        options.addOption(this.excludedNamespaces);
        options.addOption(this.includedFilePatterns);
        options.addOption(this.excludedFilePatterns);
        return options;
    }

    @Override
    protected void initOtherOptions() {
        this.buildname = Option.builder("buildname").desc("Build id, case-sensitive. Should be unique between builds.").hasArg().required().build();
        this.branchname = Option.builder("branchname").desc("Branch name, case-sensitive.").hasArg().required().build();
        this.buildsessionid = Option.builder("buildsessionid").desc("Provide build session id manually, case-sensitive.").hasArg().build();
        this.buildsessionidfile = Option.builder("buildsessionidfile").desc("Path to a file to save the build session id in (default: <user.dir>/buildSessionId.txt).").hasArg().build();
        this.includedNamespaces = Option.builder("in").longOpt("includedNamespaces").desc("For .NET agents only - Comma-separated list of namespaces to scan. Supports wildcards (* = any string, ? = any character). For example:'com.example.* ,io.*.demo, com.?ello.world'").hasArg().build();
        this.excludedNamespaces = Option.builder("en").longOpt("excludedNamespaces").desc("For .NET agents only - Comma-separated list of namespaces to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: 'com.example.* ,io.*.demo, com.?ello.world'").hasArg().build();
        this.includedFilePatterns = Option.builder("ifp").longOpt("includedFilePatterns").desc("For .NET agents only - Comma-separated list of files to scan. Supports wildcards (* = any string, ? = any character). For example:'?app.dll, *.dll'").hasArg().build();
        this.excludedFilePatterns = Option.builder("efp").longOpt("excludedFilePatterns").desc("For .NET agents only - Comma-separated list of files to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: '?app.dll, *.dll'").hasArg().build();
    }
}

