/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.config;

import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public abstract class BaseConfigModeOptions {
    private Option config;
    private Option token;
    private Option tokenfile;
    private Option appname;
    private Option proxy;
    private Option enableNoneZeroErrorCode;
    private Option packagesIncluded;
    private Option packagesExcluded;
    private String configOption;
    private String configOptionDesc;
    private boolean appOptionRequired;

    public BaseConfigModeOptions(String configOption, String configOptionDesc, boolean appOptionRequired) {
        this.configOption = configOption;
        this.configOptionDesc = configOptionDesc;
        this.appOptionRequired = appOptionRequired;
    }

    public Options getOptions() {
        Options options = new Options();
        options.addOption(this.getConfig());
        options.addOption(this.token);
        options.addOption(this.tokenfile);
        options.addOption(this.appname);
        options.addOption(this.proxy);
        options.addOption(this.packagesIncluded);
        options.addOption(this.packagesExcluded);
        options.addOption(this.enableNoneZeroErrorCode);
        return options;
    }

    protected void initOptions() {
        this.config = Option.builder(this.configOption).desc(this.configOptionDesc).required().build();
        this.token = Option.builder("token").desc("Token (mandatory. Can also be provided by 'tokenfile' argument). Case-sensitive.").hasArg().build();
        this.tokenfile = Option.builder("tokenfile").desc("A path to a file where the program can find the token. Case-sensitive.").hasArg().build();
        this.proxy = Option.builder("proxy").desc("Proxy server (optional, must be a valid URL. in the form of 'http://127.0.0.1:3333')").hasArg().build();
        this.enableNoneZeroErrorCode = Option.builder("enableNoneZeroErrorCode").desc("Indicates that the Build Scanner should return with error code in case of scan failure. On: return 1, Off: return 0").build();
        this.packagesIncluded = Option.builder("pi").longOpt("packagesincluded").desc("Comma-separated list of packages to scan. Supports wildcards (* = any string, ? = any character). For example:'com.example.* ,io.*.demo, com.?ello.world'").hasArg().build();
        this.packagesExcluded = Option.builder("pe").longOpt("packagesexcluded").desc("Comma-separated list of packages to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: 'com.example.* ,io.*.demo, com.?ello.world'").hasArg().build();
        this.initAppOption();
        this.initOtherOptions();
    }

    protected void initAppOption() {
        this.appname = this.appOptionRequired ? Option.builder("appname").desc("Application name, case-sensitive").required().hasArg().build() : Option.builder("appname").desc("Application name, case-sensitive").hasArg().build();
    }

    protected abstract void initOtherOptions();

    @Generated
    public Option getConfig() {
        return this.config;
    }

    @Generated
    public Option getToken() {
        return this.token;
    }

    @Generated
    public Option getTokenfile() {
        return this.tokenfile;
    }

    @Generated
    public Option getAppname() {
        return this.appname;
    }

    @Generated
    public Option getProxy() {
        return this.proxy;
    }

    @Generated
    public Option getEnableNoneZeroErrorCode() {
        return this.enableNoneZeroErrorCode;
    }

    @Generated
    public Option getPackagesIncluded() {
        return this.packagesIncluded;
    }

    @Generated
    public Option getPackagesExcluded() {
        return this.packagesExcluded;
    }

    @Generated
    public String getConfigOption() {
        return this.configOption;
    }

    @Generated
    public String getConfigOptionDesc() {
        return this.configOptionDesc;
    }

    @Generated
    public boolean isAppOptionRequired() {
        return this.appOptionRequired;
    }

    @Generated
    public void setConfig(Option config) {
        this.config = config;
    }

    @Generated
    public void setToken(Option token) {
        this.token = token;
    }

    @Generated
    public void setTokenfile(Option tokenfile) {
        this.tokenfile = tokenfile;
    }

    @Generated
    public void setAppname(Option appname) {
        this.appname = appname;
    }

    @Generated
    public void setProxy(Option proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setEnableNoneZeroErrorCode(Option enableNoneZeroErrorCode) {
        this.enableNoneZeroErrorCode = enableNoneZeroErrorCode;
    }

    @Generated
    public void setPackagesIncluded(Option packagesIncluded) {
        this.packagesIncluded = packagesIncluded;
    }

    @Generated
    public void setPackagesExcluded(Option packagesExcluded) {
        this.packagesExcluded = packagesExcluded;
    }

    @Generated
    public void setConfigOption(String configOption) {
        this.configOption = configOption;
    }

    @Generated
    public void setConfigOptionDesc(String configOptionDesc) {
        this.configOptionDesc = configOptionDesc;
    }

    @Generated
    public void setAppOptionRequired(boolean appOptionRequired) {
        this.appOptionRequired = appOptionRequired;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseConfigModeOptions)) {
            return false;
        }
        BaseConfigModeOptions other = (BaseConfigModeOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Option this$config = this.getConfig();
        Option other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Option this$token = this.getToken();
        Option other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        Option this$tokenfile = this.getTokenfile();
        Option other$tokenfile = other.getTokenfile();
        if (this$tokenfile == null ? other$tokenfile != null : !((Object)this$tokenfile).equals(other$tokenfile)) {
            return false;
        }
        Option this$appname = this.getAppname();
        Option other$appname = other.getAppname();
        if (this$appname == null ? other$appname != null : !((Object)this$appname).equals(other$appname)) {
            return false;
        }
        Option this$proxy = this.getProxy();
        Option other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Option this$enableNoneZeroErrorCode = this.getEnableNoneZeroErrorCode();
        Option other$enableNoneZeroErrorCode = other.getEnableNoneZeroErrorCode();
        if (this$enableNoneZeroErrorCode == null ? other$enableNoneZeroErrorCode != null : !((Object)this$enableNoneZeroErrorCode).equals(other$enableNoneZeroErrorCode)) {
            return false;
        }
        Option this$packagesIncluded = this.getPackagesIncluded();
        Option other$packagesIncluded = other.getPackagesIncluded();
        if (this$packagesIncluded == null ? other$packagesIncluded != null : !((Object)this$packagesIncluded).equals(other$packagesIncluded)) {
            return false;
        }
        Option this$packagesExcluded = this.getPackagesExcluded();
        Option other$packagesExcluded = other.getPackagesExcluded();
        if (this$packagesExcluded == null ? other$packagesExcluded != null : !((Object)this$packagesExcluded).equals(other$packagesExcluded)) {
            return false;
        }
        String this$configOption = this.getConfigOption();
        String other$configOption = other.getConfigOption();
        if (this$configOption == null ? other$configOption != null : !this$configOption.equals(other$configOption)) {
            return false;
        }
        String this$configOptionDesc = this.getConfigOptionDesc();
        String other$configOptionDesc = other.getConfigOptionDesc();
        if (this$configOptionDesc == null ? other$configOptionDesc != null : !this$configOptionDesc.equals(other$configOptionDesc)) {
            return false;
        }
        return this.isAppOptionRequired() == other.isAppOptionRequired();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseConfigModeOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Option $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Option $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        Option $tokenfile = this.getTokenfile();
        result = result * 59 + ($tokenfile == null ? 43 : ((Object)$tokenfile).hashCode());
        Option $appname = this.getAppname();
        result = result * 59 + ($appname == null ? 43 : ((Object)$appname).hashCode());
        Option $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Option $enableNoneZeroErrorCode = this.getEnableNoneZeroErrorCode();
        result = result * 59 + ($enableNoneZeroErrorCode == null ? 43 : ((Object)$enableNoneZeroErrorCode).hashCode());
        Option $packagesIncluded = this.getPackagesIncluded();
        result = result * 59 + ($packagesIncluded == null ? 43 : ((Object)$packagesIncluded).hashCode());
        Option $packagesExcluded = this.getPackagesExcluded();
        result = result * 59 + ($packagesExcluded == null ? 43 : ((Object)$packagesExcluded).hashCode());
        String $configOption = this.getConfigOption();
        result = result * 59 + ($configOption == null ? 43 : $configOption.hashCode());
        String $configOptionDesc = this.getConfigOptionDesc();
        result = result * 59 + ($configOptionDesc == null ? 43 : $configOptionDesc.hashCode());
        result = result * 59 + (this.isAppOptionRequired() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "BaseConfigModeOptions(config=" + this.getConfig() + ", token=" + this.getToken() + ", tokenfile=" + this.getTokenfile() + ", appname=" + this.getAppname() + ", proxy=" + this.getProxy() + ", enableNoneZeroErrorCode=" + this.getEnableNoneZeroErrorCode() + ", packagesIncluded=" + this.getPackagesIncluded() + ", packagesExcluded=" + this.getPackagesExcluded() + ", configOption=" + this.getConfigOption() + ", configOptionDesc=" + this.getConfigOptionDesc() + ", appOptionRequired=" + this.isAppOptionRequired() + ")";
    }
}

