/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.build;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.BaseBuildModeOptions;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ScanModeOptions
extends BaseBuildModeOptions {
    private ModesOptions.ExecMode execMode;
    private Option scan;
    private Option modules;
    private Option customerId;
    private Option server;
    private Option workspacePath;
    private Option branch;
    private Option build;
    private Option appname;
    private Option moduleName;
    private Option componentFile;
    private Option dependenciesFile;
    private Option recursive;
    private Option packagesIncluded;
    private Option packagesExcluded;
    private Option filesIncluded;
    private Option filesExcluded;
    private Option enableNoneZeroErrorCode;
    private Option pathToMetaJson;
    private Option propertiesFileName;
    private Option noPropertiesFile;
    private Option isLastModule;
    private Option sendContributors;
    private Option scmProvider;
    private Option scmVersion;
    private Option scmBaseUrl;
    private Option scm;
    private Option modulePathLength;
    private Option sourcePath;
    private Option customFilterFile;

    public ScanModeOptions(ModesOptions.ExecMode execMode) {
        this.execMode = execMode;
        this.initOptions();
    }

    @Override
    protected void initOtherOptions() {
        this.initScan();
        this.initCustomerId();
        this.initServer();
        this.initWorkspacePath();
        this.initBranch();
        this.initBuild();
        this.initAppname();
        this.initModuleName();
        this.initComponentOptions();
        this.initRecursive();
        this.initEnableNoneZeroErrorCode();
        this.initIncludesExcludes();
        this.initPathToMetaJson();
        this.initPropertiesFile();
        this.initIsLastModule();
        this.initSendContributors();
        this.initScmParams();
        this.initSourcePath();
        this.initCustomFilterFile();
    }

    @Override
    public Options getOptions() {
        Options options = super.getOptions();
        switch (this.execMode) {
            case SCAN: {
                options.addOption(this.scan);
                break;
            }
            case MODULES: {
                options.addOption(this.modules);
                options.addOption(this.modulePathLength);
                break;
            }
        }
        options.addOption(this.customerId);
        options.addOption(this.server);
        options.addOption(this.workspacePath);
        options.addOption(this.branch);
        options.addOption(this.build);
        options.addOption(this.appname);
        options.addOption(this.moduleName);
        options.addOption(this.componentFile);
        options.addOption(this.dependenciesFile);
        options.addOption(this.recursive);
        options.addOption(this.packagesIncluded);
        options.addOption(this.packagesExcluded);
        options.addOption(this.filesIncluded);
        options.addOption(this.filesExcluded);
        options.addOption(this.enableNoneZeroErrorCode);
        options.addOption(this.pathToMetaJson);
        options.addOption(this.propertiesFileName);
        options.addOption(this.noPropertiesFile);
        options.addOption(this.isLastModule);
        options.addOption(this.sendContributors);
        options.addOption(this.scmProvider);
        options.addOption(this.scmVersion);
        options.addOption(this.scmBaseUrl);
        options.addOption(this.scm);
        options.addOption(this.sourcePath);
        options.addOption(this.customFilterFile);
        return options;
    }

    public void initScan() {
        switch (this.execMode) {
            case SCAN: {
                this.scan = this.execMode.createOption();
                break;
            }
            case MODULES: {
                this.modules = this.execMode.createOption();
                this.initModulesScanParams();
                break;
            }
        }
    }

    public void initCustomerId() {
        this.customerId = Option.builder("customerid").desc("Customer ID (mandatory, unless already exists in configuration file or working with Token). Case-sensitive.").hasArg().build();
    }

    public void initServer() {
        this.server = Option.builder("server").desc("SeaLights Server URL (mandatory, unless already exists in configuration file).").hasArg().build();
    }

    public void initWorkspacePath() {
        this.workspacePath = Option.builder("workspacepath").desc("Path to the workspace where the source code exists").hasArg().build();
    }

    public void initBranch() {
        this.branch = Option.builder("branch").desc("Branch name, case-sensitive.").hasArg().build();
    }

    public void initBuild() {
        this.build = Option.builder("build").desc("Build id, case-sensitive. Should be unique between builds.").hasArg().build();
    }

    public void initAppname() {
        this.appname = Option.builder("appname").desc("Application name, case-sensitive").hasArg().build();
    }

    private void initModuleName() {
        this.moduleName = Option.builder("moduleName").desc("Module name, case-sensitive. This value should remain consistent between runs.").hasArg().build();
    }

    public void initComponentOptions() {
        this.dependenciesFile = Option.builder("df").longOpt("dependenciesFile").desc("A path to a json file that is in the following format: [{\"appName\":\"\",\"branch\":\"\",\"build\":\"\"},{...}]").hasArg().build();
        this.componentFile = Option.builder("cf").longOpt("componentfile").desc("A path to a json file with components data in the following format: [{\"appName\":\"\",\"branch\":\"\",\"build\":\"\"},{...}]").hasArg().build();
    }

    public void initRecursive() {
        this.recursive = Option.builder("r").longOpt("recursive").desc("Starts a recursive search for JARs & WARs in folder specified by the 'workspacepath' option").build();
    }

    private void initEnableNoneZeroErrorCode() {
        this.enableNoneZeroErrorCode = Option.builder("enableNoneZeroErrorCode").desc("Indicates that the Build Scanner should return with error code in case of scan failure. On: return 1, Off: return 0").build();
    }

    public void initIncludesExcludes() {
        this.packagesIncluded = Option.builder("pi").longOpt("packagesincluded").desc("Comma-separated list of packages to scan. Supports wildcards (* = any string, ? = any character). For example:'com.example.* ,io.*.demo, com.?ello.world'").hasArg().build();
        this.packagesExcluded = Option.builder("pe").longOpt("packagesexcluded").desc("Comma-separated list of packages to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: 'com.example.* ,io.*.demo, com.?ello.world'").hasArg().build();
        this.filesIncluded = Option.builder("fi").longOpt("filesincluded").desc("filesincluded").hasArg().build();
        this.filesExcluded = Option.builder("fe").longOpt("filesexcluded").desc("Comma-separated list of files to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: '*-with-dependencies.jar , bad-bad?.war, *-source.jar'").hasArg().build();
    }

    private void initPathToMetaJson() {
        this.pathToMetaJson = Option.builder("pathToMetaJson").desc("Path to a json file with metadata about the build.").hasArg().build();
    }

    public void initPropertiesFile() {
        this.propertiesFileName = Option.builder("pfn").longOpt("propertiesFileName").desc("Path in which to create the Sealights properties name. Default is 'sealights.properties'.").hasArg().build();
        this.noPropertiesFile = Option.builder("npf").longOpt("noPropertiesFile").desc("Do not generate 'sealights.properties' file.").build();
    }

    private void initIsLastModule() {
        this.isLastModule = Option.builder("isLastModule").desc("Is current module is last in build.").build();
    }

    private void initSendContributors() {
        this.sendContributors = Option.builder("sendContributors").desc("Send contributor details for advanced committer reports and features.").hasArg().build();
    }

    private void initScmParams() {
        this.scmProvider = Option.builder("scmProvider").desc("The provider name of your Source Control Management (SCM) tool. Supported values are 'Github', 'Bitbucket' and 'Gitlab'. If not used, 'Github' is assumed.").hasArg().build();
        this.scmVersion = Option.builder("scmVersion").desc("The version of your Source Control Management (SCM) tool. If left blank, cloud version is assumed. Otherwise, specify the version of your on-premise server.").hasArg().build();
        this.scmBaseUrl = Option.builder("scmBaseUrl").desc("The URL to the repository which contains the code. If left blank, the url of the remote GIT origin is being used.").hasArg().build();
        this.scm = Option.builder("scm").desc("The name of your Source Control Management (SCM) tool. Supported values are 'git' and 'none'. If not used, 'git' is assumed.").hasArg().build();
    }

    private void initModulesScanParams() {
        this.modulePathLength = Option.builder("modulePathLength").type(Number.class).desc("The length of the modules most significant path. If not provides, the default value 2 is assumed.").hasArg().build();
    }

    private void initSourcePath() {
        this.sourcePath = Option.builder("sourcePath").desc("Path to the directory where the source classes exists. The default value is workspacePath").hasArg().build();
    }

    private void initCustomFilterFile() {
        this.customFilterFile = Option.builder("customFilterFile").desc("A path to custom exclusions filter file in json format").hasArg().build();
    }
}

