/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli.build;

import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.infra.configuration.validation.ConfigValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.PackagesIncludedValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class ScanArgsValidator
implements ConfigValidator<ScanModeArguments> {
    private final PackagesIncludedValidator packagesIncludedValidator = new PackagesIncludedValidator();

    @Override
    public ValidationResult validate(ScanModeArguments scanArgs) {
        ValidationResult validationResult = new ValidationResult();
        if (StringUtils.isNullOrEmpty(scanArgs.getBuildSessionId())) {
            if (StringUtils.isNullOrEmpty(scanArgs.getAppname())) {
                validationResult.addError("'appname' must be provided, if 'buildSessionId' is not provided.");
            }
            if (StringUtils.isNullOrEmpty(scanArgs.getPackagesIncluded())) {
                validationResult.addError("'packagesincluded' must be provided, if 'buildSessionId' is not provided.");
            }
        }
        ValidationResult packagesIncludedValidationResult = this.packagesIncludedValidator.validate(scanArgs.getPackagesIncluded());
        return validationResult.add(packagesIncludedValidationResult);
    }
}

