/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli;

import io.sealights.onpremise.agents.buildscanner.main.cli.BuildModeArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeOptions;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;

public class ScanModeArgsParser
extends BuildModeArgsParser<ScanModeArguments> {
    private ModesOptions.ExecMode execMode;
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    public ScanModeArgsParser(CommandLineParser parser, ModesOptions.ExecMode execMode) {
        super(parser);
        this.execMode = execMode;
    }

    @Override
    protected ScanModeArguments createArguments(CommandLine cmdLine) throws Exception {
        return new ScanModeArguments(this.execMode, this.parseBuildGeneralAttributes(cmdLine), (String)cmdLine.getParsedOptionValue("server"), (String)cmdLine.getParsedOptionValue("customerid"), (String)cmdLine.getParsedOptionValue("workspacepath"), (String)cmdLine.getParsedOptionValue("branch"), (String)cmdLine.getParsedOptionValue("build"), (String)cmdLine.getParsedOptionValue("appname"), (String)cmdLine.getParsedOptionValue("moduleName"), this.parseComponentFile(cmdLine), cmdLine.hasOption("recursive"), (String)cmdLine.getParsedOptionValue("packagesincluded"), (String)cmdLine.getParsedOptionValue("packagesexcluded"), (String)cmdLine.getParsedOptionValue("filesincluded"), (String)cmdLine.getParsedOptionValue("filesexcluded"), cmdLine.hasOption("enableNoneZeroErrorCode"), (String)cmdLine.getParsedOptionValue("pathToMetaJson"), (String)cmdLine.getParsedOptionValue("propertiesFileName"), cmdLine.hasOption("noPropertiesFile"), (String)cmdLine.getParsedOptionValue("scmProvider"), (String)cmdLine.getParsedOptionValue("scmVersion"), (String)cmdLine.getParsedOptionValue("scmBaseUrl"), (String)cmdLine.getParsedOptionValue("scm"), this.parseModulePathLengthValue(cmdLine), (String)cmdLine.getParsedOptionValue("sourcePath"), (String)cmdLine.getParsedOptionValue("customFilterFile"));
    }

    private String parseComponentFile(CommandLine cmdLine) throws Exception {
        if (cmdLine.hasOption("componentfile")) {
            return (String)cmdLine.getParsedOptionValue("componentfile");
        }
        if (cmdLine.hasOption("dependenciesFile")) {
            CONSOLE_LOG.info("Option '{}' is deprecated, the option '{}' should be used instead", (Object)"dependenciesFile", (Object)"componentfile");
            return (String)cmdLine.getParsedOptionValue("dependenciesFile");
        }
        return null;
    }

    private Integer parseModulePathLengthValue(CommandLine cmdLine) throws Exception {
        Number modulePathLength = (Number)cmdLine.getParsedOptionValue("modulePathLength");
        return modulePathLength != null ? modulePathLength.intValue() : 2;
    }

    @Override
    protected Options getOptions() {
        return new ScanModeOptions(this.execMode).getOptions();
    }

    @Override
    public ModesOptions.ExecMode getMode() {
        return this.execMode;
    }
}

