/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class ModesOptions {
    private final Options options = this.initOptions();

    public Options getOptions() {
        return this.options;
    }

    private Options initOptions() {
        Options options = new Options();
        OptionGroup optionGroup = new OptionGroup();
        for (ExecMode execMode : ExecMode.values()) {
            optionGroup.addOption(execMode.createOption());
        }
        return options.addOptionGroup(optionGroup);
    }

    public static enum ExecMode {
        COMPONENT_UPDATE("componentUpdate", "Flag to indicate integration build components update mode"),
        COMPONENT_DELETE("componentDelete", "Flag to indicate integration build components delete mode"),
        CONFIG("config", "Flag to indicate configuration mode"),
        PRCONFIG("prConfig", "Flag to indicate pull-request configuration mode"),
        SCAN("scan", "Flag to indicate scan mode"),
        MODULES("modules", "Flag to indicate show modules mode"),
        HELP("help", "Show this help page"),
        POM("pom", "Flag to indicate pom integration mode"),
        GRADLE_INTEGRATE("gradle", "Flag to indicate Gradle build script integration mode"),
        GRADLE_RESTORE("restoreGradle", "Flag to indicate Gradle build script restoration mode"),
        RESTORE("restore", "Flag to indicate pom restore mode", "restorePom"),
        BUILDEND("buildend", "Flag to indicate build-end mode");

        private final String value;
        private final String description;
        private final String longAlias;

        public String toString() {
            return this.value;
        }

        private ExecMode(String value, String description) {
            this(value, description, null);
        }

        private ExecMode(String value, String description, String longAlias) {
            this.value = value;
            this.description = description;
            this.longAlias = longAlias;
        }

        public Option createOption() {
            Option.Builder optionBuilder = Option.builder(this.getValue()).desc(this.getDescription()).required();
            if (this.getLongAlias() != null) {
                optionBuilder.longOpt(this.getLongAlias());
            }
            return optionBuilder.build();
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLongAlias() {
            return this.longAlias;
        }
    }
}

