/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli;

import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.GradleIntegrationArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;

public abstract class ModeArgsParser<T extends ExecModeArguments> {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static Logger LOG = LogFactory.getLogger(GradleIntegrationArgsParser.class);
    private CommandLineParser parser;

    public T parse(String[] mainArgs) {
        try {
            LOG.info("parsing arguments ...");
            CommandLine cmdLine = this.parser.parse(this.getOptions(), mainArgs);
            return this.createArguments(cmdLine);
        }
        catch (Exception e) {
            this.handleParsingException(e);
            return null;
        }
    }

    public void displayHelpView() {
        HelpFormatter helpFormater = new HelpFormatter();
        int printLineWidth = 120;
        String header = String.format("options ('%s' mode):", this.getMode().name());
        helpFormater.printHelp(printLineWidth, "build-scanner", header, this.getOptions(), "", true);
    }

    protected void handleParsingException(Exception e) {
        CONSOLE_LOG.error(e.getMessage());
        LOG.error("Invalid input: {}", (Object)e.getMessage());
        this.displayHelpView();
    }

    protected abstract T createArguments(CommandLine var1) throws Exception;

    protected abstract Options getOptions();

    public abstract ModesOptions.ExecMode getMode();

    @ConstructorProperties(value={"parser"})
    @Generated
    public ModeArgsParser(CommandLineParser parser) {
        this.parser = parser;
    }

    @Generated
    public CommandLineParser getParser() {
        return this.parser;
    }
}

