/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli;

import io.sealights.onpremise.agents.buildscanner.main.cli.BuildModeArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ComponentModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ComponentModeOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;

public class ComponentModeArgsParser
extends BuildModeArgsParser<ComponentModeArguments> {
    private ModesOptions.ExecMode execMode;

    public ComponentModeArgsParser(CommandLineParser parser, ModesOptions.ExecMode execMode) {
        super(parser);
        this.execMode = execMode;
    }

    @Override
    protected ComponentModeArguments createArguments(CommandLine cmdLine) throws Exception {
        List<String> componentIds = this.extractComponentIds(cmdLine);
        String componentFile = (String)cmdLine.getParsedOptionValue("componentfile");
        return new ComponentModeArguments(this.execMode, this.parseBuildGeneralAttributes(cmdLine), componentIds, componentFile);
    }

    private List<String> extractComponentIds(CommandLine cmdLine) throws Exception {
        ArrayList<String> componentIds = new ArrayList<String>();
        if (!cmdLine.hasOption("componentids")) {
            return componentIds;
        }
        String input = (String)cmdLine.getParsedOptionValue("componentids");
        if (input == null) {
            return componentIds;
        }
        String[] ids = input.split(",");
        componentIds.addAll(Arrays.asList(ids));
        return componentIds;
    }

    @Override
    protected Options getOptions() {
        return this.createComponentOptions().getOptions();
    }

    private ComponentModeOptions.ComponentOptions createComponentOptions() {
        switch (this.execMode) {
            case COMPONENT_UPDATE: {
                return new ComponentModeOptions.ComponentUpdateOptions();
            }
            case COMPONENT_DELETE: {
                return new ComponentModeOptions.ComponentDeleteOptions();
            }
        }
        throw new RuntimeException("Invalid mode" + this.execMode.name());
    }

    @Override
    public ModesOptions.ExecMode getMode() {
        return this.execMode;
    }
}

